/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;

public class CompareFilter {
    private static final char[][] NO_CHAR_CHAR = new char[0][];
    private char[][] fExtraResourceFileFilters;
    private String[] fExtraResourceFolderFilters;

    public boolean filter(String path0, boolean folder, boolean isArchive) {
        if (!folder && this.fExtraResourceFileFilters != null) {
            char[] name = path0.toCharArray();
            int l = this.fExtraResourceFileFilters.length;
            for (int i = 0; i < l; ++i) {
                if (!this.match(this.fExtraResourceFileFilters[i], name, true)) continue;
                return true;
            }
        }
        if (folder && this.fExtraResourceFolderFilters != null) {
            int l = this.fExtraResourceFolderFilters.length;
            for (int i = 0; i < l; ++i) {
                if (!this.fExtraResourceFolderFilters[0].equals(path0)) continue;
                return true;
            }
        }
        return false;
    }

    public static String validateResourceFilters(String text) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] filters = CompareFilter.getTokens(text, ",");
        for (int i = 0; i < filters.length; ++i) {
            IStatus status;
            String fileName = filters[i].replace('*', 'x');
            int resourceType = 1;
            int lastCharacter = fileName.length() - 1;
            if (lastCharacter >= 0 && fileName.charAt(lastCharacter) == '/') {
                fileName = fileName.substring(0, lastCharacter);
                resourceType = 2;
            }
            if (!(status = workspace.validateName(fileName, resourceType)).matches(4)) continue;
            String format = Utilities.getString("ComparePreferencePage.filter.invalidsegment.error");
            return MessageFormat.format(format, status.getMessage());
        }
        return null;
    }

    public void setFilters(String filterSequence) {
        char[][] filters;
        char[][] cArray = filters = filterSequence != null && filterSequence.length() > 0 ? this.splitAndTrimOn(',', filterSequence.toCharArray()) : (char[][])null;
        if (filters == null) {
            this.fExtraResourceFileFilters = null;
            this.fExtraResourceFolderFilters = null;
        } else {
            char[] f;
            int i;
            int fileCount = 0;
            int folderCount = 0;
            int l = filters.length;
            for (i = 0; i < l; ++i) {
                f = filters[i];
                if (f.length == 0) continue;
                if (f[f.length - 1] == '/') {
                    ++folderCount;
                    continue;
                }
                ++fileCount;
            }
            this.fExtraResourceFileFilters = new char[fileCount][];
            this.fExtraResourceFolderFilters = new String[folderCount];
            l = filters.length;
            for (i = 0; i < l; ++i) {
                f = filters[i];
                if (f.length == 0) continue;
                if (f[f.length - 1] == '/') {
                    this.fExtraResourceFolderFilters[--folderCount] = new String(this.subarray(f, 0, f.length - 1));
                    continue;
                }
                this.fExtraResourceFileFilters[--fileCount] = f;
            }
        }
    }

    private static String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        for (int i = 0; i < res.length; ++i) {
            res[i] = tok.nextToken().trim();
        }
        return res;
    }

    private boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        return this.match(pattern, 0, pattern.length, name, 0, name.length, isCaseSensitive);
    }

    private boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if ((isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    private char[][] splitAndTrimOn(char divider, char[] array) {
        int start;
        int length;
        int n = length = array == null ? 0 : array.length;
        if (length == 0) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        for (int i = 0; i < length; ++i) {
            if (array[i] != divider) continue;
            ++wordCount;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        for (int i = 0; i < length; ++i) {
            int start2;
            if (array[i] != divider) continue;
            int end = i - 1;
            for (start2 = last; start2 < i && array[start2] == ' '; ++start2) {
            }
            while (end > start2 && array[end] == ' ') {
                --end;
            }
            split[currentWord] = new char[end - start2 + 1];
            System.arraycopy(array, start2, split[currentWord++], 0, end - start2 + 1);
            last = i + 1;
        }
        int end = length - 1;
        for (start = last; start < length && array[start] == ' '; ++start) {
        }
        while (end > start && array[end] == ' ') {
            --end;
        }
        split[currentWord] = new char[end - start + 1];
        System.arraycopy(array, start, split[currentWord++], 0, end - start + 1);
        return split;
    }

    private char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }
}

