/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Convert;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectID;

public class IndexCursor {
    private IndexedStore store;
    private ObjectAddress anchorAddress;
    private int entryNumber;
    private IndexNode leafNode;
    private boolean entryRemoved;

    private IndexCursor() {
    }

    IndexCursor(IndexedStore store, ObjectAddress anchorAddress) {
        this.anchorAddress = anchorAddress;
        this.store = store;
        this.leafNode = null;
        this.entryNumber = -1;
    }

    private void adjust() throws IndexedStoreException {
        if (this.leafNode == null) {
            return;
        }
        if (this.entryNumber >= this.leafNode.getNumberOfEntries()) {
            ObjectAddress next = this.leafNode.getNextAddress();
            int n = this.entryNumber - this.leafNode.getNumberOfEntries();
            this.set(next, n);
        } else if (this.entryNumber < 0) {
            ObjectAddress previous = this.leafNode.getPreviousAddress();
            int n = this.entryNumber;
            this.set(previous, n);
        }
    }

    public void close() throws IndexedStoreException {
        this.reset();
    }

    void entryInserted(int i) throws IndexedStoreException {
        if (this.entryNumber >= i) {
            ++this.entryNumber;
        }
        this.adjust();
    }

    void entryRemoved(int i) throws IndexedStoreException {
        boolean bl = this.entryRemoved = this.entryNumber == i;
        if (this.entryNumber > i) {
            --this.entryNumber;
        }
        this.adjust();
    }

    public synchronized IndexCursor find(byte[] b) throws IndexedStoreException {
        IndexAnchor anchor = this.store.acquireAnchor(this.anchorAddress);
        anchor.find(b, this);
        anchor.release();
        this.entryRemoved = false;
        return this;
    }

    public synchronized IndexCursor find(String s) throws IndexedStoreException {
        return this.find(Convert.toUTF8(s));
    }

    public synchronized IndexCursor find(Insertable i) throws IndexedStoreException {
        return this.find(i.toByteArray());
    }

    public synchronized IndexCursor findFirstEntry() throws IndexedStoreException {
        IndexAnchor anchor = this.store.acquireAnchor(this.anchorAddress);
        anchor.findFirstEntry(this);
        anchor.release();
        this.entryRemoved = false;
        return this;
    }

    public synchronized IndexCursor findLastEntry() throws IndexedStoreException {
        IndexAnchor anchor = this.store.acquireAnchor(this.anchorAddress);
        anchor.findLastEntry(this);
        anchor.release();
        this.entryRemoved = false;
        return this;
    }

    public synchronized byte[] getKey() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return null;
        }
        byte[] key = this.leafNode.getKey(this.entryNumber);
        return key;
    }

    public synchronized String getKeyAsString() throws IndexedStoreException {
        byte[] key = this.getKey();
        if (key == null) {
            return null;
        }
        String s = Convert.fromUTF8(key);
        int i = s.indexOf(0);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    public synchronized byte[] getValue() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return null;
        }
        byte[] value = this.leafNode.getValue(this.entryNumber);
        return value;
    }

    ObjectAddress getValueAsObjectAddress() throws IndexedStoreException {
        byte[] value = this.getValue();
        if (value == null) {
            return null;
        }
        return new ObjectAddress(value);
    }

    public synchronized ObjectID getValueAsObjectID() throws IndexedStoreException {
        byte[] value = this.getValue();
        if (value == null) {
            return null;
        }
        return new ObjectID(value);
    }

    public synchronized String getValueAsString() throws IndexedStoreException {
        byte[] value = this.getValue();
        if (value == null) {
            return null;
        }
        return Convert.fromUTF8(value);
    }

    public synchronized boolean isAtBeginning() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        return this.leafNode == null;
    }

    public synchronized boolean isAtEnd() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        return this.leafNode == null;
    }

    public synchronized boolean isSet() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        return this.leafNode != null;
    }

    public synchronized boolean keyEquals(byte[] b) throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return false;
        }
        byte[] key = this.leafNode.getKey(this.entryNumber);
        if (b.length != key.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (key[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean keyEquals(String s) throws IndexedStoreException {
        return this.keyEquals(Convert.toUTF8(s));
    }

    public synchronized boolean keyEquals(Insertable anObject) throws IndexedStoreException {
        return this.keyEquals(anObject.toByteArray());
    }

    public synchronized boolean keyMatches(byte[] b) throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return false;
        }
        byte[] key = this.leafNode.getKey(this.entryNumber);
        if (key.length < b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (key[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean keyMatches(String s) throws IndexedStoreException {
        return this.keyMatches(Convert.toUTF8(s));
    }

    public synchronized boolean keyMatches(Insertable anObject) throws IndexedStoreException {
        return this.keyMatches(anObject.toByteArray());
    }

    public synchronized IndexCursor next() throws IndexedStoreException {
        if (this.isAtBeginning()) {
            this.findFirstEntry();
        } else {
            ++this.entryNumber;
            this.adjust();
        }
        return this;
    }

    void nodeSplit() throws IndexedStoreException {
        this.adjust();
    }

    public synchronized IndexCursor previous() throws IndexedStoreException {
        if (this.isAtEnd()) {
            this.findLastEntry();
        } else {
            --this.entryNumber;
            this.adjust();
        }
        return this;
    }

    public synchronized void remove() throws IndexedStoreException {
        this.removeEntry();
    }

    void removeEntry() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return;
        }
        ObjectAddress address = this.leafNode.getAddress();
        this.leafNode.removeEntry(this.entryNumber);
        this.entryRemoved = false;
        while (!address.isNull()) {
            IndexNode node = this.store.acquireNode(address);
            if (node.getNumberOfEntries() > 0) {
                node.release();
                break;
            }
            ObjectAddress parentAddress = node.getParentAddress();
            node.unlink();
            node.release();
            this.store.removeObject(address);
            address = parentAddress;
        }
    }

    public synchronized void reset() throws IndexedStoreException {
        this.unset();
        this.entryRemoved = false;
    }

    void set(ObjectAddress leafNodeAddress, int entryNumber) throws IndexedStoreException {
        this.unset();
        if (leafNodeAddress.isNull()) {
            return;
        }
        this.leafNode = this.store.acquireNode(leafNodeAddress);
        this.leafNode.addCursor(this);
        this.entryNumber = entryNumber >= 0 ? entryNumber : this.leafNode.getNumberOfEntries() + entryNumber;
        this.adjust();
    }

    private void unset() throws IndexedStoreException {
        if (this.leafNode != null) {
            this.leafNode.removeCursor(this);
            this.leafNode.release();
        }
        this.entryNumber = -1;
        this.leafNode = null;
        this.entryRemoved = false;
    }

    void updateEntry(byte[] b) throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (b.length > 2048) {
            throw new IndexedStoreException(3);
        }
        if (this.leafNode == null) {
            return;
        }
        this.leafNode.updateValueAt(this.entryNumber, b);
    }

    public synchronized void updateValue(byte[] b) throws IndexedStoreException {
        this.updateEntry(b);
    }

    public synchronized void updateValue(String s) throws IndexedStoreException {
        this.updateValue(Convert.toUTF8(s));
    }

    public synchronized void updateValue(Insertable anObject) throws IndexedStoreException {
        this.updateValue(anObject.toByteArray());
    }
}

