/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public abstract class JUnitRenameParticipant
extends RenameParticipant {
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        List launchConfigTypes = JUnitPlugin.getDefault().getJUnitLaunchConfigTypeIDs();
        ArrayList changes = new ArrayList();
        Iterator types = launchConfigTypes.iterator();
        while (types.hasNext()) {
            String typeId = (String)types.next();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            this.createChangeForConfigs(changes, configs);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        if (changes.size() > 0) {
            return new CompositeChange(this.getChangeName(), changes.toArray(new Change[changes.size()]));
        }
        return null;
    }

    protected String getChangeName() {
        return JUnitMessages.getString("TypeRenameParticipant.change.name");
    }

    protected abstract void createChangeForConfigs(List var1, ILaunchConfiguration[] var2) throws CoreException;
}

