/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class PushFieldVariable
extends CompoundInstruction {
    private String fDeclaringTypeSignature;
    private String fName;
    private int fSuperClassLevel;

    public PushFieldVariable(String name, int superClassLevel, int start) {
        super(start);
        this.fName = name;
        this.fSuperClassLevel = superClassLevel;
    }

    public PushFieldVariable(String name, String declaringTypeSignature, int start) {
        super(start);
        this.fName = name;
        this.fDeclaringTypeSignature = declaringTypeSignature;
    }

    public void execute() throws CoreException {
        IJavaObject receiver = (IJavaObject)this.popValue();
        IJavaFieldVariable field = null;
        field = this.fDeclaringTypeSignature == null ? ((JDIObjectValue)receiver).getField(this.fName, this.fSuperClassLevel) : receiver.getField(this.fName, this.fDeclaringTypeSignature);
        if (field == null) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("PushFieldVariable.Cannot_find_the_field_{0}_for_the_object_{1}_1"), this.fName, receiver.toString()), null));
        }
        this.push(field);
    }

    public String toString() {
        return MessageFormat.format(InstructionsEvaluationMessages.getString("PushFieldVariable.push_field_{0}_2"), this.fName);
    }
}

