/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import java.util.StringTokenizer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.feature.BaseFeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class PatchSpecPage
extends BaseFeatureSpecPage {
    public PatchSpecPage(WizardNewProjectCreationPage mainPage) {
        super(mainPage, true);
        this.setTitle(PDEPlugin.getResourceString("PatchSpec.title"));
        this.setDescription(PDEPlugin.getResourceString("PatchSpec.desc"));
    }

    protected void initialize() {
        if (this.isInitialized) {
            return;
        }
        String projectName = this.mainPage.getProjectName();
        if (this.initialId == null) {
            this.patchIdText.setText(this.computeInitialId(projectName));
        }
        if (this.initialName == null) {
            this.patchNameText.setText(projectName);
        }
        this.setErrorMessage(null);
        super.initialize();
    }

    protected void verifyComplete() {
        String message = this.verifyIdRules();
        if (message != null) {
            this.setPageComplete(false);
            this.setErrorMessage(message);
            return;
        }
        message = this.verifyVersion();
        if (message != null) {
            this.setPageComplete(false);
            this.setErrorMessage(message);
            return;
        }
        if (this.customChoice.getSelection() && this.libraryText.getText().length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage(PDEPlugin.getResourceString("NewFeatureWizard.SpecPage.error.library"));
            return;
        }
        IFeatureModel[] featureModels = this.getAllFeatureModels();
        for (int i = 0; i < featureModels.length; ++i) {
            IFeature feature = featureModels[i].getFeature();
            if (!feature.getId().equals(this.featureIdText.getText()) || !feature.getVersion().equals(this.featureVersionText.getText())) continue;
            this.fFeatureToPatch = feature.getModel();
            this.setMessage(null);
            this.setPageComplete(true);
            this.setErrorMessage(null);
            return;
        }
        this.fFeatureToPatch = null;
        this.setMessage(PDEPlugin.getFormattedMessage("NewFeaturePatch.SpecPage.notFound", this.featureIdText.getText()), 2);
        this.setErrorMessage(null);
        this.getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        if (this.fFeatureToPatch == null) {
            return null;
        }
        return super.getNextPage();
    }

    private String getPatchId() {
        if (this.patchIdText == null) {
            return "";
        }
        return this.patchIdText.getText();
    }

    private String getPatchName() {
        if (this.patchNameText == null) {
            return "";
        }
        return this.patchNameText.getText();
    }

    private String getPatchProvider() {
        if (this.patchProviderText == null) {
            return "";
        }
        return this.patchProviderText.getText();
    }

    public FeatureData getFeatureData() {
        FeatureData data = new FeatureData();
        data.id = this.getPatchId();
        data.version = "1.0.0";
        data.provider = this.getPatchProvider();
        data.name = this.getPatchName();
        data.library = this.getInstallHandlerLibrary();
        data.hasCustomHandler = this.customChoice.getSelection();
        data.isPatch = true;
        data.featureToPatchId = this.featureIdText.getText();
        data.featureToPatchVersion = this.featureVersionText.getText();
        return data;
    }

    protected String verifyIdRules() {
        String problemText = PDEPlugin.getResourceString("NewFeatureWizard.SpecPage.invalidId");
        String name = this.patchIdText.getText();
        if (name == null || name.length() == 0) {
            return PDEPlugin.getResourceString("NewFeatureWizard.SpecPage.pmissing");
        }
        StringTokenizer stok = new StringTokenizer(name, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            for (int i = 0; i < token.length(); ++i) {
                if (Character.isLetterOrDigit(token.charAt(i))) continue;
                return problemText;
            }
        }
        return super.verifyIdRules();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
            this.isInitialized = true;
            this.patchIdText.setFocus();
        }
    }
}

