/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.resources.IProject;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ExtensionAttributeRow {
    protected IContextPart part;
    protected Object att;
    protected IPluginElement input;
    protected boolean blockNotification;
    protected boolean dirty;

    public ExtensionAttributeRow(IContextPart part, ISchemaAttribute att) {
        this.part = part;
        this.att = att;
    }

    public ExtensionAttributeRow(IContextPart part, IPluginAttribute att) {
        this.part = part;
        this.att = att;
    }

    public ISchemaAttribute getAttribute() {
        return this.att instanceof ISchemaAttribute ? (ISchemaAttribute)this.att : null;
    }

    public String getName() {
        if (this.att instanceof ISchemaAttribute) {
            return ((ISchemaAttribute)this.att).getName();
        }
        return ((IPluginAttribute)this.att).getName();
    }

    protected int getUse() {
        if (this.att instanceof ISchemaAttribute) {
            return ((ISchemaAttribute)this.att).getUse();
        }
        return 0;
    }

    protected String getDescription() {
        if (this.att instanceof ISchemaAttribute) {
            return ((ISchemaAttribute)this.att).getDescription();
        }
        return "";
    }

    protected String getValue() {
        IPluginAttribute patt;
        String value = "";
        if (this.input != null && (patt = this.input.getAttribute(this.getName())) != null) {
            value = patt.getValue();
        }
        return value;
    }

    protected String getPropertyLabel() {
        String label = this.getName();
        label = this.getUse() == 1 ? label + "*:" : label + ":";
        return label;
    }

    protected void createLabel(Composite parent, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, this.getPropertyLabel(), 0);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText(this.getToolTipText());
    }

    protected String getToolTipText() {
        String text = this.getDescription();
        if (text == null) {
            return null;
        }
        int dot = text.indexOf(46);
        if (dot != -1) {
            StringBuffer buf = new StringBuffer();
            boolean inTag = false;
            for (int i = 0; i < text.length(); ++i) {
                char c2;
                char c = text.charAt(i);
                if (inTag) {
                    if (c != '>') continue;
                    inTag = false;
                    continue;
                }
                if (c == '<') {
                    inTag = true;
                    continue;
                }
                if (c == '.' && i < text.length() - 1 && ((c2 = text.charAt(i + 1)) == ' ' || c2 == '\t' || c2 == '\n')) break;
                buf.append(c);
            }
            return buf.toString();
        }
        return text;
    }

    public abstract void createContents(Composite var1, FormToolkit var2, int var3);

    protected abstract void update();

    public abstract void commit();

    public abstract void setFocus();

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
        this.part.fireSaveNeeded();
    }

    public void dispose() {
    }

    public void setInput(IPluginElement input) {
        this.input = input;
        this.update();
    }

    protected IProject getProject() {
        return this.part.getPage().getPDEEditor().getCommonProject();
    }
}

