/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ExtensionAttributeRow;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BooleanAttributeRow
extends ExtensionAttributeRow {
    private Button button;

    public BooleanAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        this.createLabel(parent, toolkit);
        this.button = toolkit.createButton(parent, "", 32);
        GridData gd = new GridData();
        gd.horizontalSpan = span - 1;
        this.button.setLayoutData((Object)gd);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!BooleanAttributeRow.this.blockNotification) {
                    BooleanAttributeRow.this.markDirty();
                }
                BooleanAttributeRow.this.updateText();
            }
        });
        this.button.setEnabled(this.part.isEditable());
    }

    protected void update() {
        Object dvalue;
        ISchemaAttribute att;
        boolean state;
        this.blockNotification = true;
        String value = this.getValue();
        boolean bl = state = value != null && value.toLowerCase().equals("true");
        if (value == null && (att = this.getAttribute()).getUse() == 2 && (dvalue = att.getValue()) != null && dvalue.equals("true")) {
            state = true;
        }
        this.button.setSelection(state);
        this.updateText();
        this.blockNotification = false;
    }

    private void updateText() {
        String value = this.getValue();
        boolean state = this.button.getSelection();
        if (value != null) {
            this.button.setText(state ? "true" : "false");
        } else {
            this.button.setText("");
        }
    }

    public void commit() {
        if (this.dirty && this.input != null) {
            try {
                this.input.setAttribute(this.getName(), this.button.getSelection() ? "true" : "false");
                this.dirty = false;
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void setFocus() {
        this.button.setFocus();
    }
}

