/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class ClasspathHelper {
    public static String getDevEntriesProperties(String fileName, boolean checkExcluded) {
        File directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || directory.exists() && !directory.isFile())) {
            directory.mkdirs();
        }
        Properties properties = new Properties();
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] models = manager.getAllModels();
        for (int i = 0; i < models.length; ++i) {
            String entry;
            String id = models[i].getPluginBase().getId();
            if (id == null || (entry = ClasspathHelper.writeEntry(ClasspathHelper.getOutputFolders(models[i], checkExcluded))).length() <= 0) continue;
            properties.put(id, entry);
        }
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            properties.store(stream, "");
            stream.flush();
            stream.close();
            return new URL("file:" + fileName).toString();
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
            return ClasspathHelper.getDevEntries(checkExcluded);
        }
    }

    public static String getDevEntries(boolean checkExcluded) {
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] models = manager.getAllModels();
        ArrayList<IPath> list = new ArrayList<IPath>();
        for (int i = 0; i < models.length; ++i) {
            String id = models[i].getPluginBase().getId();
            if (id == null || id.trim().length() == 0) continue;
            IPath[] paths = ClasspathHelper.getOutputFolders(models[i], checkExcluded);
            for (int j = 0; j < paths.length; ++j) {
                list.add(paths[j]);
            }
        }
        String entry = ClasspathHelper.writeEntry(list.toArray(new IPath[list.size()]));
        return entry.length() > 0 ? entry : "bin";
    }

    private static String writeEntry(IPath[] paths) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            buffer.append(paths[i].toString());
            if (i >= paths.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private static IPath[] getOutputFolders(IPluginModelBase model, boolean checkExcluded) {
        ArrayList result = new ArrayList();
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                List excluded = ClasspathHelper.getFoldersToExclude(project, checkExcluded);
                IPath path = jProject.getOutputLocation();
                if (path != null && !excluded.contains(path)) {
                    ClasspathHelper.addPath(result, project, path);
                }
                IClasspathEntry[] entries = jProject.getRawClasspath();
                for (int i = 0; i < entries.length; ++i) {
                    if (entries[i].getContentKind() != 1 || entries[i].getEntryKind() != 3 || (path = entries[i].getOutputLocation()) == null || excluded.contains(path)) continue;
                    ClasspathHelper.addPath(result, project, path);
                }
            }
        }
        catch (JavaModelException e) {
        }
        catch (CoreException e) {
            // empty catch block
        }
        return result.toArray(new IPath[result.size()]);
    }

    private static void addPath(ArrayList result, IProject project, IPath path) {
        if (path.getDevice() == null && path.segmentCount() >= 1 && path.segment(0).equals(project.getName()) && (path = path.removeFirstSegments(1)).segmentCount() == 0) {
            path = new Path(".");
        }
        if (!result.contains(path)) {
            result.add(path);
        }
    }

    private static List getFoldersToExclude(IProject project, boolean checkExcluded) {
        IEclipsePreferences pref;
        ArrayList<Path> list = new ArrayList<Path>();
        if (checkExcluded && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            String binExcludes = pref.get("selfhosting.binExcludes", "");
            StringTokenizer tokenizer = new StringTokenizer(binExcludes, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(new Path(tokenizer.nextToken().trim()));
            }
        }
        return list;
    }
}

