/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.WizardFileSystemExportPage1;
import org.eclipse.ui.wizards.datatransfer.ZipFileExportOperation;

class WizardZipFileExportPage1
extends WizardFileSystemExportPage1 {
    protected Button overwriteExistingFileCheckbox;
    protected Button createDirectoryStructureCheckbox;
    protected Button compressContentsCheckbox;
    protected static final int COMBO_HISTORY_LENGTH = 5;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardZipFileExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILE_ID = "WizardZipFileExportPage1.STORE_OVERWRITE_EXISTING_FILE_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardZipFileExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_COMPRESS_CONTENTS_ID = "WizardZipFileExportPage1.STORE_COMPRESS_CONTENTS_ID";

    protected WizardZipFileExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardZipFileExportPage1(IStructuredSelection selection) {
        this("zipFileExportPage1", selection);
        this.setTitle(DataTransferMessages.getString("ZipExport.exportTitle"));
        this.setDescription(DataTransferMessages.getString("ZipExport.description"));
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.overwriteExistingFileCheckbox = new Button(optionsGroup, 16416);
        this.overwriteExistingFileCheckbox.setText(DataTransferMessages.getString("ZipExport.overwriteFile"));
        this.createDirectoryStructureCheckbox = new Button(optionsGroup, 16416);
        this.createDirectoryStructureCheckbox.setText(DataTransferMessages.getString("ExportFile.createDirectoryStructure"));
        this.compressContentsCheckbox = new Button(optionsGroup, 16416);
        this.compressContentsCheckbox.setText(DataTransferMessages.getString("ZipExport.compressContents"));
        this.createDirectoryStructureCheckbox.setSelection(true);
        this.compressContentsCheckbox.setSelection(true);
    }

    protected boolean ensureTargetDirectoryIsValid(String fullPathname) {
        int separatorIndex = fullPathname.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        return this.ensureTargetIsValid(new File(fullPathname.substring(0, separatorIndex)));
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipExport.mustBeFile"));
            this.giveFocusToDestination();
            return false;
        }
        if (targetFile.exists()) {
            if (!this.overwriteExistingFileCheckbox.getSelection() && targetFile.canWrite() && !this.queryYesNoQuestion(DataTransferMessages.getString("ZipExport.alreadyExists"))) {
                return false;
            }
            if (!targetFile.canWrite()) {
                this.displayErrorDialog(DataTransferMessages.getString("ZipExport.alreadyExistsError"));
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String targetPath = this.getDestinationValue();
        if (!this.ensureTargetDirectoryIsValid(targetPath)) {
            return false;
        }
        return this.ensureTargetFileIsValid(new File(targetPath));
    }

    protected boolean executeExportOperation(ZipFileExportOperation op) {
        op.setCreateLeadupStructure(this.createDirectoryStructureCheckbox.getSelection());
        op.setUseCompression(this.compressContentsCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException().getMessage());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.exportProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        List resourcesToExport = this.getSelectedResources();
        this.saveWidgetValues();
        if (resourcesToExport.size() > 0) {
            return this.executeExportOperation(new ZipFileExportOperation(null, resourcesToExport, this.getDestinationValue()));
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.information"), (String)DataTransferMessages.getString("FileExport.noneSelected"));
        return false;
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.getString("ZipExport.destinationLabel");
    }

    protected String getDestinationValue() {
        String requiredSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (!destinationText.toLowerCase().endsWith(requiredSuffix.toLowerCase())) {
            destinationText = destinationText + requiredSuffix;
        }
        return destinationText;
    }

    protected String getOutputSuffix() {
        return ".zip";
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.setDestinationValue(selectedFileName);
        }
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            String[] newDirectoryNames = new String[directoryNames.length + 1];
            System.arraycopy(directoryNames, 0, newDirectoryNames, 1, directoryNames.length);
            newDirectoryNames[0] = this.getDestinationValue();
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_OVERWRITE_EXISTING_FILE_ID, this.overwriteExistingFileCheckbox.getSelection());
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureCheckbox.getSelection());
            settings.put(STORE_COMPRESS_CONTENTS_ID, this.compressContentsCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            for (int i = 0; i < directoryNames.length; ++i) {
                this.addDestinationItem(directoryNames[i]);
            }
            this.overwriteExistingFileCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILE_ID));
            this.createDirectoryStructureCheckbox.setSelection(settings.getBoolean(STORE_CREATE_STRUCTURE_ID));
            this.compressContentsCheckbox.setSelection(settings.getBoolean(STORE_COMPRESS_CONTENTS_ID));
        }
    }
}

