/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.registry.SynchronizeWizardDescription;
import org.eclipse.team.internal.ui.synchronize.SynchronizeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class GlobalRefreshWizardSelectionPage
extends WizardPage
implements IDoubleClickListener,
ISelectionChangedListener {
    private TableViewer fViewer;
    private IWizard wizard;
    private List createdImages;

    public GlobalRefreshWizardSelectionPage() {
        super(Policy.bind("GlobalRefreshParticipantSelectionPage.0"));
        this.setDescription(Policy.bind("GlobalRefreshParticipantSelectionPage.1"));
        this.setTitle(Policy.bind("GlobalRefreshParticipantSelectionPage.2"));
    }

    public void dispose() {
        if (this.createdImages != null) {
            Iterator it = this.createdImages.iterator();
            while (it.hasNext()) {
                Image image = (Image)it.next();
                image.dispose();
            }
        }
    }

    public void createControl(Composite parent2) {
        Composite top = new Composite(parent2, 0);
        top.setLayout((Layout)new GridLayout());
        this.setControl((Control)top);
        Label l = new Label(top, 0);
        l.setText(Policy.bind("GlobalRefreshParticipantSelectionPage.3"));
        this.fViewer = new TableViewer(top, 2048);
        GridData data = new GridData(1808);
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.fViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.fViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        this.fViewer.setInput((Object)TeamUI.getSynchronizeManager());
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fViewer.getTable().setFocus();
        Dialog.applyDialogFont((Control)parent2);
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)event.getViewer(), event.getViewer().getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            this.wizard = null;
            this.setPageComplete(false);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            this.wizard = null;
            this.setPageComplete(false);
            return;
        }
        SynchronizeWizardDescription selectedDescriptor = (SynchronizeWizardDescription)ss.getFirstElement();
        try {
            this.wizard = selectedDescriptor.createWizard();
            this.wizard.addPages();
            this.setPageComplete(true);
            this.setDescription(selectedDescriptor.getDescription());
        }
        catch (CoreException e) {
            Utils.handle(e);
            this.setPageComplete(false);
        }
    }

    public IWizard getSelectedWizard() {
        return this.wizard;
    }

    public IWizardPage getNextPage() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getStartingPage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fViewer.getTable().setFocus();
        }
    }

    class MyLabelProvider
    extends LabelProvider {
        MyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof SynchronizeWizardDescription) {
                SynchronizeWizardDescription descriptor = (SynchronizeWizardDescription)element;
                return descriptor.getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof SynchronizeWizardDescription) {
                SynchronizeWizardDescription descriptor = (SynchronizeWizardDescription)element;
                ImageDescriptor d = descriptor.getImageDescriptor();
                if (GlobalRefreshWizardSelectionPage.this.createdImages == null) {
                    GlobalRefreshWizardSelectionPage.this.createdImages = new ArrayList(3);
                }
                Image image = d.createImage();
                GlobalRefreshWizardSelectionPage.this.createdImages.add(image);
                return image;
            }
            return null;
        }
    }

    class MyContentProvider
    extends BaseWorkbenchContentProvider {
        MyContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof SynchronizeManager) {
                SynchronizeManager manager = (SynchronizeManager)element;
                return manager.getWizardDescriptors();
            }
            return super.getChildren(element);
        }
    }
}

