/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class FormLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;

    int computeHeight(FormData data) {
        FormAttachment top = data.getTopAttachment(this.spacing);
        FormAttachment bottom = data.getBottomAttachment(this.spacing);
        FormAttachment height = bottom.minus(top);
        if (height.numerator == 0) {
            if (bottom.numerator == 0) {
                return bottom.offset;
            }
            if (bottom.numerator == bottom.denominator) {
                return -top.offset;
            }
            if (bottom.offset <= 0) {
                return -top.offset * top.denominator / bottom.numerator;
            }
            int divider = bottom.denominator - bottom.numerator;
            return bottom.denominator * bottom.offset / divider;
        }
        return height.solveY(data.cacheHeight);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, 0, 0, flushCache);
        size.x += this.marginWidth * 2;
        size.y += this.marginHeight * 2;
        return size;
    }

    Point computeSize(Control control, boolean flushCache) {
        FormData data = (FormData)control.getLayoutData();
        if (data == null) {
            data = new FormData();
            control.setLayoutData(data);
        }
        return control.computeSize(data.width, data.height, flushCache);
    }

    int computeWidth(FormData data) {
        FormAttachment left = data.getLeftAttachment(this.spacing);
        FormAttachment right = data.getRightAttachment(this.spacing);
        FormAttachment width = right.minus(left);
        if (width.numerator == 0) {
            if (right.numerator == 0) {
                return right.offset;
            }
            if (right.numerator == right.denominator) {
                return -left.offset;
            }
            if (right.offset <= 0) {
                return -left.offset * left.denominator / left.numerator;
            }
            int divider = right.denominator - right.numerator;
            return right.denominator * right.offset / divider;
        }
        return width.solveY(data.cacheWidth);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        int x = rect.x + this.marginWidth;
        int y = rect.y + this.marginHeight;
        int width = Math.max(0, rect.width - 2 * this.marginWidth);
        int height = Math.max(0, rect.height - 2 * this.marginHeight);
        this.layout(composite, true, x, y, width, height, flushCache);
    }

    Point layout(Composite composite, boolean move, int x, int y, int width, int height, boolean flushCache) {
        Control child;
        int i;
        FormData data;
        Control[] children = composite.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            Control child2 = children[i2];
            Point size = this.computeSize(child2, flushCache);
            data = (FormData)child2.getLayoutData();
            data.cacheWidth = size.x;
            data.cacheHeight = size.y;
            data.cacheBottom = null;
            data.cacheTop = null;
            data.cacheRight = null;
            data.cacheLeft = null;
        }
        Rectangle[] bounds = null;
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            data = (FormData)child.getLayoutData();
            if (move) {
                int x1 = data.getLeftAttachment(this.spacing).solveX(width);
                int y1 = data.getTopAttachment(this.spacing).solveX(height);
                int x2 = data.getRightAttachment(this.spacing).solveX(width);
                int y2 = data.getBottomAttachment(this.spacing).solveX(height);
                if (bounds == null) {
                    bounds = new Rectangle[children.length];
                }
                bounds[i] = new Rectangle(x + x1, y + y1, x2 - x1, y2 - y1);
                continue;
            }
            width = Math.max(this.computeWidth(data), width);
            height = Math.max(this.computeHeight(data), height);
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            data = (FormData)child.getLayoutData();
            data.cacheHeight = 0;
            data.cacheWidth = 0;
            data.cacheBottom = null;
            data.cacheTop = null;
            data.cacheRight = null;
            data.cacheLeft = null;
        }
        if (move) {
            for (i = 0; i < children.length; ++i) {
                children[i].setBounds((Rectangle)bounds[i]);
            }
        }
        return move ? null : new Point(width, height);
    }
}

