/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class JavaElement
extends PlatformObject
implements IJavaElement {
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_JAVAPROJECT = '=';
    public static final char JEM_PACKAGEFRAGMENTROOT = '/';
    public static final char JEM_PACKAGEFRAGMENT = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_INITIALIZER = '|';
    public static final char JEM_COMPILATIONUNIT = '{';
    public static final char JEM_CLASSFILE = '(';
    public static final char JEM_TYPE = '[';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public int occurrenceCount = 1;
    protected JavaElement parent;
    protected String name;
    protected static final JavaElement[] NO_ELEMENTS = new JavaElement[0];
    protected static final Object NO_INFO = new Object();

    protected JavaElement(JavaElement parent, String name) throws IllegalArgumentException {
        this.parent = parent;
        this.name = name;
    }

    public void close() throws JavaModelException {
        JavaModelManager.getJavaModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws JavaModelException;

    protected abstract Object createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        JavaElement other = (JavaElement)o;
        return this.occurrenceCount == other.occurrenceCount && this.name.equals(other.name) && this.parent.equals(other.parent);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        return false;
    }

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int length = mementoName.length();
        for (int i = 0; i < length; ++i) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '%': 
                case '(': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
        }
    }

    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public IDOMNode findNode(IDOMCompilationUnit dom) {
        int type = this.getElementType();
        if (type == 5 || type == 8 || type == 13 || type == 10 || type == 9 || type == 11 || type == 7) {
            ArrayList<JavaElement> path = new ArrayList<JavaElement>();
            for (IJavaElement element = this; element != null && element.getElementType() != 5; element = element.getParent()) {
                if (element.getElementType() == 12) continue;
                path.add(0, (JavaElement)element);
            }
            if (path.size() == 0) {
                if (this.equalsDOMNode(dom)) {
                    return dom;
                }
                return null;
            }
            return ((JavaElement)path.get(0)).followPath(path, 0, dom.getFirstChild());
        }
        return null;
    }

    protected IDOMNode followPath(ArrayList path, int position, IDOMNode node) {
        if (this.equalsDOMNode(node)) {
            if (position == path.size() - 1) {
                return node;
            }
            if (node.getFirstChild() != null) {
                return ((JavaElement)path.get(++position)).followPath(path, position, node.getFirstChild());
            }
            return null;
        }
        if (node.getNextNode() != null) {
            return this.followPath(path, position, node.getNextNode());
        }
        return null;
    }

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws JavaModelException;

    public IJavaElement getAncestor(int ancestorType) {
        for (IJavaElement element = this; element != null; element = element.getParent()) {
            if (element.getElementType() != ancestorType) continue;
            return element;
        }
        return null;
    }

    public IJavaElement[] getChildren() throws JavaModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    public ArrayList getChildrenOfType(int type) throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<JavaElement> list = new ArrayList<JavaElement>(size);
        for (int i = 0; i < size; ++i) {
            JavaElement elt = (JavaElement)children[i];
            if (elt.getElementType() != type) continue;
            list.add(elt);
        }
        return list;
    }

    public IClassFile getClassFile() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        return null;
    }

    public Object getElementInfo() throws JavaModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    public String getElementName() {
        return this.name;
    }

    public abstract IJavaElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    public IJavaElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public IJavaElement getHandleUpdatingCountFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        this.occurrenceCount = Integer.parseInt(memento.nextToken());
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    protected abstract char getHandleMementoDelimiter();

    public IJavaModel getJavaModel() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaModel)) continue;
            return (IJavaModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IJavaProject getJavaProject() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaProject)) continue;
            return (IJavaProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public IJavaElement getParent() {
        return this.parent;
    }

    public IJavaElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    protected IJavaElement getSourceElementAt(int position) throws JavaModelException {
        if (this instanceof ISourceReference) {
            IJavaElement[] children = this.getChildren();
            for (int i = children.length - 1; i >= 0; --i) {
                IJavaElement aChild = children[i];
                if (!(aChild instanceof SourceRefElement)) continue;
                SourceRefElement child = (SourceRefElement)children[i];
                ISourceRange range = child.getSourceRange();
                int start = range.getOffset();
                int end = start + range.getLength();
                if (start > position || position > end) continue;
                if (child instanceof IField) {
                    int declarationStart = start;
                    SourceRefElement candidate = null;
                    do {
                        if (position > (range = ((IField)((Object)child)).getNameRange()).getOffset() + range.getLength()) {
                            return candidate == null ? child.getSourceElementAt(position) : candidate.getSourceElementAt(position);
                        }
                        candidate = child;
                        SourceRefElement sourceRefElement = child = --i >= 0 ? (SourceRefElement)children[i] : null;
                    } while (child != null && child.getSourceRange().getOffset() == declarationStart);
                    return candidate.getSourceElementAt(position);
                }
                if (child instanceof IParent) {
                    return child.getSourceElementAt(position);
                }
                return child;
            }
        } else {
            Assert.isTrue(false);
        }
        return this;
    }

    public SourceMapper getSourceMapper() {
        return ((JavaElement)this.getParent()).getSourceMapper();
    }

    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.getResource();
        if (resource == null) {
            class NoResourceSchedulingRule
            implements ISchedulingRule {
                public IPath path;

                public NoResourceSchedulingRule(IPath path) {
                    this.path = path;
                }

                public boolean contains(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        return this.path.isPrefixOf(((NoResourceSchedulingRule)rule).path);
                    }
                    return false;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        IPath otherPath = ((NoResourceSchedulingRule)rule).path;
                        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
                    }
                    return false;
                }
            }
            return new NoResourceSchedulingRule(this.getPath());
        }
        return resource;
    }

    public boolean hasChildren() throws JavaModelException {
        Object elementInfo = JavaModelManager.getJavaModelManager().getInfo(this);
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IJavaElement e) {
        IJavaElement parentElement;
        for (parentElement = e.getParent(); parentElement != null && !parentElement.equals(this); parentElement = parentElement.getParent()) {
        }
        return parentElement != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((JavaElementInfo)this.getElementInfo()).isStructureKnown();
    }

    protected JavaModelException newNotPresentException() {
        return new JavaModelException(new JavaModelStatus(969, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        try {
            HashMap newElements = manager.getTemporaryCache();
            this.generateInfos(info, newElements, monitor);
            if (info == null) {
                info = newElements.get(this);
            }
            if (info == null) {
                Openable openable = (Openable)this.getOpenable();
                if (newElements.containsKey(openable)) {
                    openable.closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                manager.putInfos(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
        return info;
    }

    public String readableName() {
        return this.getElementName();
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        for (int i = tab; i > 0; --i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        JavaElement parentElement = (JavaElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaElement[] children = ((JavaElementInfo)info).getChildren();
        for (int i = 0; i < children.length; ++i) {
            buffer.append("\n");
            ((JavaElement)children[i]).toString(tab + 1, buffer);
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getElementName());
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }
}

