/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.NaiveASTFlattener;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public abstract class ASTNode {
    public static final int ANONYMOUS_CLASS_DECLARATION = 1;
    public static final int ARRAY_ACCESS = 2;
    public static final int ARRAY_CREATION = 3;
    public static final int ARRAY_INITIALIZER = 4;
    public static final int ARRAY_TYPE = 5;
    public static final int ASSERT_STATEMENT = 6;
    public static final int ASSIGNMENT = 7;
    public static final int BLOCK = 8;
    public static final int BOOLEAN_LITERAL = 9;
    public static final int BREAK_STATEMENT = 10;
    public static final int CAST_EXPRESSION = 11;
    public static final int CATCH_CLAUSE = 12;
    public static final int CHARACTER_LITERAL = 13;
    public static final int CLASS_INSTANCE_CREATION = 14;
    public static final int COMPILATION_UNIT = 15;
    public static final int CONDITIONAL_EXPRESSION = 16;
    public static final int CONSTRUCTOR_INVOCATION = 17;
    public static final int CONTINUE_STATEMENT = 18;
    public static final int DO_STATEMENT = 19;
    public static final int EMPTY_STATEMENT = 20;
    public static final int EXPRESSION_STATEMENT = 21;
    public static final int FIELD_ACCESS = 22;
    public static final int FIELD_DECLARATION = 23;
    public static final int FOR_STATEMENT = 24;
    public static final int IF_STATEMENT = 25;
    public static final int IMPORT_DECLARATION = 26;
    public static final int INFIX_EXPRESSION = 27;
    public static final int INITIALIZER = 28;
    public static final int JAVADOC = 29;
    public static final int LABELED_STATEMENT = 30;
    public static final int METHOD_DECLARATION = 31;
    public static final int METHOD_INVOCATION = 32;
    public static final int NULL_LITERAL = 33;
    public static final int NUMBER_LITERAL = 34;
    public static final int PACKAGE_DECLARATION = 35;
    public static final int PARENTHESIZED_EXPRESSION = 36;
    public static final int POSTFIX_EXPRESSION = 37;
    public static final int PREFIX_EXPRESSION = 38;
    public static final int PRIMITIVE_TYPE = 39;
    public static final int QUALIFIED_NAME = 40;
    public static final int RETURN_STATEMENT = 41;
    public static final int SIMPLE_NAME = 42;
    public static final int SIMPLE_TYPE = 43;
    public static final int SINGLE_VARIABLE_DECLARATION = 44;
    public static final int STRING_LITERAL = 45;
    public static final int SUPER_CONSTRUCTOR_INVOCATION = 46;
    public static final int SUPER_FIELD_ACCESS = 47;
    public static final int SUPER_METHOD_INVOCATION = 48;
    public static final int SWITCH_CASE = 49;
    public static final int SWITCH_STATEMENT = 50;
    public static final int SYNCHRONIZED_STATEMENT = 51;
    public static final int THIS_EXPRESSION = 52;
    public static final int THROW_STATEMENT = 53;
    public static final int TRY_STATEMENT = 54;
    public static final int TYPE_DECLARATION = 55;
    public static final int TYPE_DECLARATION_STATEMENT = 56;
    public static final int TYPE_LITERAL = 57;
    public static final int VARIABLE_DECLARATION_EXPRESSION = 58;
    public static final int VARIABLE_DECLARATION_FRAGMENT = 59;
    public static final int VARIABLE_DECLARATION_STATEMENT = 60;
    public static final int WHILE_STATEMENT = 61;
    public static final int INSTANCEOF_EXPRESSION = 62;
    public static final int LINE_COMMENT = 63;
    public static final int BLOCK_COMMENT = 64;
    public static final int TAG_ELEMENT = 65;
    public static final int TEXT_ELEMENT = 66;
    public static final int MEMBER_REF = 67;
    public static final int METHOD_REF = 68;
    public static final int METHOD_REF_PARAMETER = 69;
    public static final int ENHANCED_FOR_STATEMENT = 70;
    public static final int ENUM_DECLARATION = 71;
    public static final int ENUM_CONSTANT_DECLARATION = 72;
    public static final int TYPE_PARAMETER = 73;
    public static final int PARAMETERIZED_TYPE = 74;
    public static final int QUALIFIED_TYPE = 75;
    public static final int WILDCARD_TYPE = 76;
    public static final int NORMAL_ANNOTATION = 77;
    public static final int MARKER_ANNOTATION = 78;
    public static final int SINGLE_MEMBER_ANNOTATION = 79;
    public static final int MEMBER_VALUE_PAIR = 80;
    public static final int ANNOTATION_TYPE_DECLARATION = 81;
    public static final int ANNOTATION_TYPE_MEMBER_DECLARATION = 82;
    public static final int MODIFIER = 83;
    final AST ast;
    private ASTNode parent = null;
    private static Map UNMODIFIABLE_EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    private Object property1 = null;
    private Object property2 = null;
    private int startPosition = -1;
    private int length = 0;
    public static final int MALFORMED = 1;
    public static final int ORIGINAL = 2;
    public static final int PROTECT = 4;
    int typeAndFlags = 0;
    private StructuralPropertyDescriptor location = null;
    static boolean CYCLE_RISK = true;
    static boolean NO_CYCLE_RISK = false;
    static boolean MANDATORY = true;
    static boolean OPTIONAL = false;
    static List tempPDL = null;
    static final int HEADERS = 12;
    static final int BASE_NODE_SIZE = 40;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AnnotationTypeDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AnnotationTypeMemberDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ArrayAccess;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ArrayCreation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ArrayInitializer;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ArrayType;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AssertStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Assignment;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Block;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$BlockComment;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$BooleanLiteral;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$BreakStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CastExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CatchClause;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CharacterLiteral;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ClassInstanceCreation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CompilationUnit;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ConditionalExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ConstructorInvocation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ContinueStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$DoStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$EmptyStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$EnhancedForStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$EnumConstantDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$EnumDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ExpressionStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$FieldAccess;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$FieldDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ForStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$IfStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ImportDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$InfixExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Initializer;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$InstanceofExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Javadoc;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$LabeledStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$LineComment;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MarkerAnnotation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MemberRef;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MemberValuePair;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodInvocation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodRef;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodRefParameter;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Modifier;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$NormalAnnotation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$NullLiteral;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$NumberLiteral;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PackageDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ParameterizedType;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ParenthesizedExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PostfixExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PrefixExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PrimitiveType;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$QualifiedName;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$QualifiedType;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ReturnStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SimpleName;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SimpleType;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SingleMemberAnnotation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SingleVariableDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$StringLiteral;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SuperConstructorInvocation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SuperFieldAccess;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SuperMethodInvocation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SwitchCase;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SwitchStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SynchronizedStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TagElement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TextElement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ThisExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ThrowStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TryStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclarationStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeLiteral;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeParameter;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$VariableDeclarationExpression;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$VariableDeclarationFragment;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$VariableDeclarationStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$WhileStatement;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$WildcardType;

    public static Class nodeClassForType(int nodeType) {
        switch (nodeType) {
            case 81: {
                return class$org$eclipse$jdt$core$dom$AnnotationTypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$AnnotationTypeDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.AnnotationTypeDeclaration")) : class$org$eclipse$jdt$core$dom$AnnotationTypeDeclaration;
            }
            case 82: {
                return class$org$eclipse$jdt$core$dom$AnnotationTypeMemberDeclaration == null ? (class$org$eclipse$jdt$core$dom$AnnotationTypeMemberDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration")) : class$org$eclipse$jdt$core$dom$AnnotationTypeMemberDeclaration;
            }
            case 1: {
                return class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration == null ? (class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.AnonymousClassDeclaration")) : class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration;
            }
            case 2: {
                return class$org$eclipse$jdt$core$dom$ArrayAccess == null ? (class$org$eclipse$jdt$core$dom$ArrayAccess = ASTNode.class$("org.eclipse.jdt.core.dom.ArrayAccess")) : class$org$eclipse$jdt$core$dom$ArrayAccess;
            }
            case 3: {
                return class$org$eclipse$jdt$core$dom$ArrayCreation == null ? (class$org$eclipse$jdt$core$dom$ArrayCreation = ASTNode.class$("org.eclipse.jdt.core.dom.ArrayCreation")) : class$org$eclipse$jdt$core$dom$ArrayCreation;
            }
            case 4: {
                return class$org$eclipse$jdt$core$dom$ArrayInitializer == null ? (class$org$eclipse$jdt$core$dom$ArrayInitializer = ASTNode.class$("org.eclipse.jdt.core.dom.ArrayInitializer")) : class$org$eclipse$jdt$core$dom$ArrayInitializer;
            }
            case 5: {
                return class$org$eclipse$jdt$core$dom$ArrayType == null ? (class$org$eclipse$jdt$core$dom$ArrayType = ASTNode.class$("org.eclipse.jdt.core.dom.ArrayType")) : class$org$eclipse$jdt$core$dom$ArrayType;
            }
            case 6: {
                return class$org$eclipse$jdt$core$dom$AssertStatement == null ? (class$org$eclipse$jdt$core$dom$AssertStatement = ASTNode.class$("org.eclipse.jdt.core.dom.AssertStatement")) : class$org$eclipse$jdt$core$dom$AssertStatement;
            }
            case 7: {
                return class$org$eclipse$jdt$core$dom$Assignment == null ? (class$org$eclipse$jdt$core$dom$Assignment = ASTNode.class$("org.eclipse.jdt.core.dom.Assignment")) : class$org$eclipse$jdt$core$dom$Assignment;
            }
            case 8: {
                return class$org$eclipse$jdt$core$dom$Block == null ? (class$org$eclipse$jdt$core$dom$Block = ASTNode.class$("org.eclipse.jdt.core.dom.Block")) : class$org$eclipse$jdt$core$dom$Block;
            }
            case 64: {
                return class$org$eclipse$jdt$core$dom$BlockComment == null ? (class$org$eclipse$jdt$core$dom$BlockComment = ASTNode.class$("org.eclipse.jdt.core.dom.BlockComment")) : class$org$eclipse$jdt$core$dom$BlockComment;
            }
            case 9: {
                return class$org$eclipse$jdt$core$dom$BooleanLiteral == null ? (class$org$eclipse$jdt$core$dom$BooleanLiteral = ASTNode.class$("org.eclipse.jdt.core.dom.BooleanLiteral")) : class$org$eclipse$jdt$core$dom$BooleanLiteral;
            }
            case 10: {
                return class$org$eclipse$jdt$core$dom$BreakStatement == null ? (class$org$eclipse$jdt$core$dom$BreakStatement = ASTNode.class$("org.eclipse.jdt.core.dom.BreakStatement")) : class$org$eclipse$jdt$core$dom$BreakStatement;
            }
            case 11: {
                return class$org$eclipse$jdt$core$dom$CastExpression == null ? (class$org$eclipse$jdt$core$dom$CastExpression = ASTNode.class$("org.eclipse.jdt.core.dom.CastExpression")) : class$org$eclipse$jdt$core$dom$CastExpression;
            }
            case 12: {
                return class$org$eclipse$jdt$core$dom$CatchClause == null ? (class$org$eclipse$jdt$core$dom$CatchClause = ASTNode.class$("org.eclipse.jdt.core.dom.CatchClause")) : class$org$eclipse$jdt$core$dom$CatchClause;
            }
            case 13: {
                return class$org$eclipse$jdt$core$dom$CharacterLiteral == null ? (class$org$eclipse$jdt$core$dom$CharacterLiteral = ASTNode.class$("org.eclipse.jdt.core.dom.CharacterLiteral")) : class$org$eclipse$jdt$core$dom$CharacterLiteral;
            }
            case 14: {
                return class$org$eclipse$jdt$core$dom$ClassInstanceCreation == null ? (class$org$eclipse$jdt$core$dom$ClassInstanceCreation = ASTNode.class$("org.eclipse.jdt.core.dom.ClassInstanceCreation")) : class$org$eclipse$jdt$core$dom$ClassInstanceCreation;
            }
            case 15: {
                return class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = ASTNode.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit;
            }
            case 16: {
                return class$org$eclipse$jdt$core$dom$ConditionalExpression == null ? (class$org$eclipse$jdt$core$dom$ConditionalExpression = ASTNode.class$("org.eclipse.jdt.core.dom.ConditionalExpression")) : class$org$eclipse$jdt$core$dom$ConditionalExpression;
            }
            case 17: {
                return class$org$eclipse$jdt$core$dom$ConstructorInvocation == null ? (class$org$eclipse$jdt$core$dom$ConstructorInvocation = ASTNode.class$("org.eclipse.jdt.core.dom.ConstructorInvocation")) : class$org$eclipse$jdt$core$dom$ConstructorInvocation;
            }
            case 18: {
                return class$org$eclipse$jdt$core$dom$ContinueStatement == null ? (class$org$eclipse$jdt$core$dom$ContinueStatement = ASTNode.class$("org.eclipse.jdt.core.dom.ContinueStatement")) : class$org$eclipse$jdt$core$dom$ContinueStatement;
            }
            case 19: {
                return class$org$eclipse$jdt$core$dom$DoStatement == null ? (class$org$eclipse$jdt$core$dom$DoStatement = ASTNode.class$("org.eclipse.jdt.core.dom.DoStatement")) : class$org$eclipse$jdt$core$dom$DoStatement;
            }
            case 20: {
                return class$org$eclipse$jdt$core$dom$EmptyStatement == null ? (class$org$eclipse$jdt$core$dom$EmptyStatement = ASTNode.class$("org.eclipse.jdt.core.dom.EmptyStatement")) : class$org$eclipse$jdt$core$dom$EmptyStatement;
            }
            case 70: {
                return class$org$eclipse$jdt$core$dom$EnhancedForStatement == null ? (class$org$eclipse$jdt$core$dom$EnhancedForStatement = ASTNode.class$("org.eclipse.jdt.core.dom.EnhancedForStatement")) : class$org$eclipse$jdt$core$dom$EnhancedForStatement;
            }
            case 72: {
                return class$org$eclipse$jdt$core$dom$EnumConstantDeclaration == null ? (class$org$eclipse$jdt$core$dom$EnumConstantDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.EnumConstantDeclaration")) : class$org$eclipse$jdt$core$dom$EnumConstantDeclaration;
            }
            case 71: {
                return class$org$eclipse$jdt$core$dom$EnumDeclaration == null ? (class$org$eclipse$jdt$core$dom$EnumDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.EnumDeclaration")) : class$org$eclipse$jdt$core$dom$EnumDeclaration;
            }
            case 21: {
                return class$org$eclipse$jdt$core$dom$ExpressionStatement == null ? (class$org$eclipse$jdt$core$dom$ExpressionStatement = ASTNode.class$("org.eclipse.jdt.core.dom.ExpressionStatement")) : class$org$eclipse$jdt$core$dom$ExpressionStatement;
            }
            case 22: {
                return class$org$eclipse$jdt$core$dom$FieldAccess == null ? (class$org$eclipse$jdt$core$dom$FieldAccess = ASTNode.class$("org.eclipse.jdt.core.dom.FieldAccess")) : class$org$eclipse$jdt$core$dom$FieldAccess;
            }
            case 23: {
                return class$org$eclipse$jdt$core$dom$FieldDeclaration == null ? (class$org$eclipse$jdt$core$dom$FieldDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.FieldDeclaration")) : class$org$eclipse$jdt$core$dom$FieldDeclaration;
            }
            case 24: {
                return class$org$eclipse$jdt$core$dom$ForStatement == null ? (class$org$eclipse$jdt$core$dom$ForStatement = ASTNode.class$("org.eclipse.jdt.core.dom.ForStatement")) : class$org$eclipse$jdt$core$dom$ForStatement;
            }
            case 25: {
                return class$org$eclipse$jdt$core$dom$IfStatement == null ? (class$org$eclipse$jdt$core$dom$IfStatement = ASTNode.class$("org.eclipse.jdt.core.dom.IfStatement")) : class$org$eclipse$jdt$core$dom$IfStatement;
            }
            case 26: {
                return class$org$eclipse$jdt$core$dom$ImportDeclaration == null ? (class$org$eclipse$jdt$core$dom$ImportDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.ImportDeclaration")) : class$org$eclipse$jdt$core$dom$ImportDeclaration;
            }
            case 27: {
                return class$org$eclipse$jdt$core$dom$InfixExpression == null ? (class$org$eclipse$jdt$core$dom$InfixExpression = ASTNode.class$("org.eclipse.jdt.core.dom.InfixExpression")) : class$org$eclipse$jdt$core$dom$InfixExpression;
            }
            case 28: {
                return class$org$eclipse$jdt$core$dom$Initializer == null ? (class$org$eclipse$jdt$core$dom$Initializer = ASTNode.class$("org.eclipse.jdt.core.dom.Initializer")) : class$org$eclipse$jdt$core$dom$Initializer;
            }
            case 62: {
                return class$org$eclipse$jdt$core$dom$InstanceofExpression == null ? (class$org$eclipse$jdt$core$dom$InstanceofExpression = ASTNode.class$("org.eclipse.jdt.core.dom.InstanceofExpression")) : class$org$eclipse$jdt$core$dom$InstanceofExpression;
            }
            case 29: {
                return class$org$eclipse$jdt$core$dom$Javadoc == null ? (class$org$eclipse$jdt$core$dom$Javadoc = ASTNode.class$("org.eclipse.jdt.core.dom.Javadoc")) : class$org$eclipse$jdt$core$dom$Javadoc;
            }
            case 30: {
                return class$org$eclipse$jdt$core$dom$LabeledStatement == null ? (class$org$eclipse$jdt$core$dom$LabeledStatement = ASTNode.class$("org.eclipse.jdt.core.dom.LabeledStatement")) : class$org$eclipse$jdt$core$dom$LabeledStatement;
            }
            case 63: {
                return class$org$eclipse$jdt$core$dom$LineComment == null ? (class$org$eclipse$jdt$core$dom$LineComment = ASTNode.class$("org.eclipse.jdt.core.dom.LineComment")) : class$org$eclipse$jdt$core$dom$LineComment;
            }
            case 78: {
                return class$org$eclipse$jdt$core$dom$MarkerAnnotation == null ? (class$org$eclipse$jdt$core$dom$MarkerAnnotation = ASTNode.class$("org.eclipse.jdt.core.dom.MarkerAnnotation")) : class$org$eclipse$jdt$core$dom$MarkerAnnotation;
            }
            case 67: {
                return class$org$eclipse$jdt$core$dom$MemberRef == null ? (class$org$eclipse$jdt$core$dom$MemberRef = ASTNode.class$("org.eclipse.jdt.core.dom.MemberRef")) : class$org$eclipse$jdt$core$dom$MemberRef;
            }
            case 80: {
                return class$org$eclipse$jdt$core$dom$MemberValuePair == null ? (class$org$eclipse$jdt$core$dom$MemberValuePair = ASTNode.class$("org.eclipse.jdt.core.dom.MemberValuePair")) : class$org$eclipse$jdt$core$dom$MemberValuePair;
            }
            case 31: {
                return class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration;
            }
            case 32: {
                return class$org$eclipse$jdt$core$dom$MethodInvocation == null ? (class$org$eclipse$jdt$core$dom$MethodInvocation = ASTNode.class$("org.eclipse.jdt.core.dom.MethodInvocation")) : class$org$eclipse$jdt$core$dom$MethodInvocation;
            }
            case 68: {
                return class$org$eclipse$jdt$core$dom$MethodRef == null ? (class$org$eclipse$jdt$core$dom$MethodRef = ASTNode.class$("org.eclipse.jdt.core.dom.MethodRef")) : class$org$eclipse$jdt$core$dom$MethodRef;
            }
            case 69: {
                return class$org$eclipse$jdt$core$dom$MethodRefParameter == null ? (class$org$eclipse$jdt$core$dom$MethodRefParameter = ASTNode.class$("org.eclipse.jdt.core.dom.MethodRefParameter")) : class$org$eclipse$jdt$core$dom$MethodRefParameter;
            }
            case 83: {
                return class$org$eclipse$jdt$core$dom$Modifier == null ? (class$org$eclipse$jdt$core$dom$Modifier = ASTNode.class$("org.eclipse.jdt.core.dom.Modifier")) : class$org$eclipse$jdt$core$dom$Modifier;
            }
            case 77: {
                return class$org$eclipse$jdt$core$dom$NormalAnnotation == null ? (class$org$eclipse$jdt$core$dom$NormalAnnotation = ASTNode.class$("org.eclipse.jdt.core.dom.NormalAnnotation")) : class$org$eclipse$jdt$core$dom$NormalAnnotation;
            }
            case 33: {
                return class$org$eclipse$jdt$core$dom$NullLiteral == null ? (class$org$eclipse$jdt$core$dom$NullLiteral = ASTNode.class$("org.eclipse.jdt.core.dom.NullLiteral")) : class$org$eclipse$jdt$core$dom$NullLiteral;
            }
            case 34: {
                return class$org$eclipse$jdt$core$dom$NumberLiteral == null ? (class$org$eclipse$jdt$core$dom$NumberLiteral = ASTNode.class$("org.eclipse.jdt.core.dom.NumberLiteral")) : class$org$eclipse$jdt$core$dom$NumberLiteral;
            }
            case 35: {
                return class$org$eclipse$jdt$core$dom$PackageDeclaration == null ? (class$org$eclipse$jdt$core$dom$PackageDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.PackageDeclaration")) : class$org$eclipse$jdt$core$dom$PackageDeclaration;
            }
            case 74: {
                return class$org$eclipse$jdt$core$dom$ParameterizedType == null ? (class$org$eclipse$jdt$core$dom$ParameterizedType = ASTNode.class$("org.eclipse.jdt.core.dom.ParameterizedType")) : class$org$eclipse$jdt$core$dom$ParameterizedType;
            }
            case 36: {
                return class$org$eclipse$jdt$core$dom$ParenthesizedExpression == null ? (class$org$eclipse$jdt$core$dom$ParenthesizedExpression = ASTNode.class$("org.eclipse.jdt.core.dom.ParenthesizedExpression")) : class$org$eclipse$jdt$core$dom$ParenthesizedExpression;
            }
            case 37: {
                return class$org$eclipse$jdt$core$dom$PostfixExpression == null ? (class$org$eclipse$jdt$core$dom$PostfixExpression = ASTNode.class$("org.eclipse.jdt.core.dom.PostfixExpression")) : class$org$eclipse$jdt$core$dom$PostfixExpression;
            }
            case 38: {
                return class$org$eclipse$jdt$core$dom$PrefixExpression == null ? (class$org$eclipse$jdt$core$dom$PrefixExpression = ASTNode.class$("org.eclipse.jdt.core.dom.PrefixExpression")) : class$org$eclipse$jdt$core$dom$PrefixExpression;
            }
            case 39: {
                return class$org$eclipse$jdt$core$dom$PrimitiveType == null ? (class$org$eclipse$jdt$core$dom$PrimitiveType = ASTNode.class$("org.eclipse.jdt.core.dom.PrimitiveType")) : class$org$eclipse$jdt$core$dom$PrimitiveType;
            }
            case 40: {
                return class$org$eclipse$jdt$core$dom$QualifiedName == null ? (class$org$eclipse$jdt$core$dom$QualifiedName = ASTNode.class$("org.eclipse.jdt.core.dom.QualifiedName")) : class$org$eclipse$jdt$core$dom$QualifiedName;
            }
            case 75: {
                return class$org$eclipse$jdt$core$dom$QualifiedType == null ? (class$org$eclipse$jdt$core$dom$QualifiedType = ASTNode.class$("org.eclipse.jdt.core.dom.QualifiedType")) : class$org$eclipse$jdt$core$dom$QualifiedType;
            }
            case 41: {
                return class$org$eclipse$jdt$core$dom$ReturnStatement == null ? (class$org$eclipse$jdt$core$dom$ReturnStatement = ASTNode.class$("org.eclipse.jdt.core.dom.ReturnStatement")) : class$org$eclipse$jdt$core$dom$ReturnStatement;
            }
            case 42: {
                return class$org$eclipse$jdt$core$dom$SimpleName == null ? (class$org$eclipse$jdt$core$dom$SimpleName = ASTNode.class$("org.eclipse.jdt.core.dom.SimpleName")) : class$org$eclipse$jdt$core$dom$SimpleName;
            }
            case 43: {
                return class$org$eclipse$jdt$core$dom$SimpleType == null ? (class$org$eclipse$jdt$core$dom$SimpleType = ASTNode.class$("org.eclipse.jdt.core.dom.SimpleType")) : class$org$eclipse$jdt$core$dom$SimpleType;
            }
            case 79: {
                return class$org$eclipse$jdt$core$dom$SingleMemberAnnotation == null ? (class$org$eclipse$jdt$core$dom$SingleMemberAnnotation = ASTNode.class$("org.eclipse.jdt.core.dom.SingleMemberAnnotation")) : class$org$eclipse$jdt$core$dom$SingleMemberAnnotation;
            }
            case 44: {
                return class$org$eclipse$jdt$core$dom$SingleVariableDeclaration == null ? (class$org$eclipse$jdt$core$dom$SingleVariableDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.SingleVariableDeclaration")) : class$org$eclipse$jdt$core$dom$SingleVariableDeclaration;
            }
            case 45: {
                return class$org$eclipse$jdt$core$dom$StringLiteral == null ? (class$org$eclipse$jdt$core$dom$StringLiteral = ASTNode.class$("org.eclipse.jdt.core.dom.StringLiteral")) : class$org$eclipse$jdt$core$dom$StringLiteral;
            }
            case 46: {
                return class$org$eclipse$jdt$core$dom$SuperConstructorInvocation == null ? (class$org$eclipse$jdt$core$dom$SuperConstructorInvocation = ASTNode.class$("org.eclipse.jdt.core.dom.SuperConstructorInvocation")) : class$org$eclipse$jdt$core$dom$SuperConstructorInvocation;
            }
            case 47: {
                return class$org$eclipse$jdt$core$dom$SuperFieldAccess == null ? (class$org$eclipse$jdt$core$dom$SuperFieldAccess = ASTNode.class$("org.eclipse.jdt.core.dom.SuperFieldAccess")) : class$org$eclipse$jdt$core$dom$SuperFieldAccess;
            }
            case 48: {
                return class$org$eclipse$jdt$core$dom$SuperMethodInvocation == null ? (class$org$eclipse$jdt$core$dom$SuperMethodInvocation = ASTNode.class$("org.eclipse.jdt.core.dom.SuperMethodInvocation")) : class$org$eclipse$jdt$core$dom$SuperMethodInvocation;
            }
            case 49: {
                return class$org$eclipse$jdt$core$dom$SwitchCase == null ? (class$org$eclipse$jdt$core$dom$SwitchCase = ASTNode.class$("org.eclipse.jdt.core.dom.SwitchCase")) : class$org$eclipse$jdt$core$dom$SwitchCase;
            }
            case 50: {
                return class$org$eclipse$jdt$core$dom$SwitchStatement == null ? (class$org$eclipse$jdt$core$dom$SwitchStatement = ASTNode.class$("org.eclipse.jdt.core.dom.SwitchStatement")) : class$org$eclipse$jdt$core$dom$SwitchStatement;
            }
            case 51: {
                return class$org$eclipse$jdt$core$dom$SynchronizedStatement == null ? (class$org$eclipse$jdt$core$dom$SynchronizedStatement = ASTNode.class$("org.eclipse.jdt.core.dom.SynchronizedStatement")) : class$org$eclipse$jdt$core$dom$SynchronizedStatement;
            }
            case 65: {
                return class$org$eclipse$jdt$core$dom$TagElement == null ? (class$org$eclipse$jdt$core$dom$TagElement = ASTNode.class$("org.eclipse.jdt.core.dom.TagElement")) : class$org$eclipse$jdt$core$dom$TagElement;
            }
            case 66: {
                return class$org$eclipse$jdt$core$dom$TextElement == null ? (class$org$eclipse$jdt$core$dom$TextElement = ASTNode.class$("org.eclipse.jdt.core.dom.TextElement")) : class$org$eclipse$jdt$core$dom$TextElement;
            }
            case 52: {
                return class$org$eclipse$jdt$core$dom$ThisExpression == null ? (class$org$eclipse$jdt$core$dom$ThisExpression = ASTNode.class$("org.eclipse.jdt.core.dom.ThisExpression")) : class$org$eclipse$jdt$core$dom$ThisExpression;
            }
            case 53: {
                return class$org$eclipse$jdt$core$dom$ThrowStatement == null ? (class$org$eclipse$jdt$core$dom$ThrowStatement = ASTNode.class$("org.eclipse.jdt.core.dom.ThrowStatement")) : class$org$eclipse$jdt$core$dom$ThrowStatement;
            }
            case 54: {
                return class$org$eclipse$jdt$core$dom$TryStatement == null ? (class$org$eclipse$jdt$core$dom$TryStatement = ASTNode.class$("org.eclipse.jdt.core.dom.TryStatement")) : class$org$eclipse$jdt$core$dom$TryStatement;
            }
            case 55: {
                return class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = ASTNode.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration;
            }
            case 56: {
                return class$org$eclipse$jdt$core$dom$TypeDeclarationStatement == null ? (class$org$eclipse$jdt$core$dom$TypeDeclarationStatement = ASTNode.class$("org.eclipse.jdt.core.dom.TypeDeclarationStatement")) : class$org$eclipse$jdt$core$dom$TypeDeclarationStatement;
            }
            case 57: {
                return class$org$eclipse$jdt$core$dom$TypeLiteral == null ? (class$org$eclipse$jdt$core$dom$TypeLiteral = ASTNode.class$("org.eclipse.jdt.core.dom.TypeLiteral")) : class$org$eclipse$jdt$core$dom$TypeLiteral;
            }
            case 73: {
                return class$org$eclipse$jdt$core$dom$TypeParameter == null ? (class$org$eclipse$jdt$core$dom$TypeParameter = ASTNode.class$("org.eclipse.jdt.core.dom.TypeParameter")) : class$org$eclipse$jdt$core$dom$TypeParameter;
            }
            case 58: {
                return class$org$eclipse$jdt$core$dom$VariableDeclarationExpression == null ? (class$org$eclipse$jdt$core$dom$VariableDeclarationExpression = ASTNode.class$("org.eclipse.jdt.core.dom.VariableDeclarationExpression")) : class$org$eclipse$jdt$core$dom$VariableDeclarationExpression;
            }
            case 59: {
                return class$org$eclipse$jdt$core$dom$VariableDeclarationFragment == null ? (class$org$eclipse$jdt$core$dom$VariableDeclarationFragment = ASTNode.class$("org.eclipse.jdt.core.dom.VariableDeclarationFragment")) : class$org$eclipse$jdt$core$dom$VariableDeclarationFragment;
            }
            case 60: {
                return class$org$eclipse$jdt$core$dom$VariableDeclarationStatement == null ? (class$org$eclipse$jdt$core$dom$VariableDeclarationStatement = ASTNode.class$("org.eclipse.jdt.core.dom.VariableDeclarationStatement")) : class$org$eclipse$jdt$core$dom$VariableDeclarationStatement;
            }
            case 61: {
                return class$org$eclipse$jdt$core$dom$WhileStatement == null ? (class$org$eclipse$jdt$core$dom$WhileStatement = ASTNode.class$("org.eclipse.jdt.core.dom.WhileStatement")) : class$org$eclipse$jdt$core$dom$WhileStatement;
            }
            case 76: {
                return class$org$eclipse$jdt$core$dom$WildcardType == null ? (class$org$eclipse$jdt$core$dom$WildcardType = ASTNode.class$("org.eclipse.jdt.core.dom.WildcardType")) : class$org$eclipse$jdt$core$dom$WildcardType;
            }
        }
        throw new IllegalArgumentException();
    }

    ASTNode(AST ast) {
        if (ast == null) {
            throw new IllegalArgumentException();
        }
        this.ast = ast;
        this.setNodeType(this.getNodeType0());
        this.setFlags(ast.getDefaultNodeFlag());
    }

    public final AST getAST() {
        return this.ast;
    }

    public final ASTNode getParent() {
        return this.parent;
    }

    public final StructuralPropertyDescriptor getLocationInParent() {
        return this.location;
    }

    public final ASTNode getRoot() {
        ASTNode candidate = this;
        ASTNode p;
        while ((p = candidate.getParent()) != null) {
            candidate = p;
        }
        return candidate;
    }

    public final Object getStructuralProperty(StructuralPropertyDescriptor property) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.TYPE) {
                int result = this.internalGetSetIntProperty(p, true, 0);
                return new Integer(result);
            }
            if (p.getValueType() == Boolean.TYPE) {
                boolean result = this.internalGetSetBooleanProperty(p, true, false);
                return result;
            }
            return this.internalGetSetObjectProperty(p, true, null);
        }
        if (property instanceof ChildPropertyDescriptor) {
            return this.internalGetSetChildProperty((ChildPropertyDescriptor)property, true, null);
        }
        if (property instanceof ChildListPropertyDescriptor) {
            return this.internalGetChildListProperty((ChildListPropertyDescriptor)property);
        }
        throw new IllegalArgumentException();
    }

    public final void setStructuralProperty(StructuralPropertyDescriptor property, Object value) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.TYPE) {
                int arg = (Integer)value;
                this.internalGetSetIntProperty(p, false, arg);
                return;
            }
            if (p.getValueType() == Boolean.TYPE) {
                boolean arg = (Boolean)value;
                this.internalGetSetBooleanProperty(p, false, arg);
                return;
            }
            if (value == null && p.isMandatory()) {
                throw new IllegalArgumentException();
            }
            this.internalGetSetObjectProperty(p, false, value);
            return;
        }
        if (property instanceof ChildPropertyDescriptor) {
            ChildPropertyDescriptor p = (ChildPropertyDescriptor)property;
            ASTNode child = (ASTNode)value;
            if (child == null && p.isMandatory()) {
                throw new IllegalArgumentException();
            }
            this.internalGetSetChildProperty(p, false, child);
            return;
        }
        if (property instanceof ChildListPropertyDescriptor) {
            throw new IllegalArgumentException("Cannot set the list of child list property");
        }
    }

    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        throw new RuntimeException("Node does not have this property");
    }

    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        throw new RuntimeException("Node does not have this property");
    }

    Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        throw new RuntimeException("Node does not have this property");
    }

    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        throw new RuntimeException("Node does not have this property");
    }

    List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        throw new RuntimeException("Node does not have this property");
    }

    public final List structuralPropertiesForType() {
        return this.internalStructuralPropertiesForType(this.ast.apiLevel);
    }

    abstract List internalStructuralPropertiesForType(int var1);

    static void createPropertyList(Class nodeClass) {
        tempPDL = new ArrayList(5);
        tempPDL.add(nodeClass);
    }

    static void addProperty(StructuralPropertyDescriptor property) {
        Class nodeClass = (Class)tempPDL.get(0);
        if (property.getNodeClass() != nodeClass) {
            throw new RuntimeException("Structural property descriptor has wrong node class!");
        }
        tempPDL.add(property);
    }

    static List reapPropertyList() {
        tempPDL.remove(0);
        ArrayList a = new ArrayList(tempPDL.size());
        a.addAll(tempPDL);
        tempPDL = null;
        return Collections.unmodifiableList(a);
    }

    final void unsupportedIn2() {
        if (this.ast.apiLevel == 2) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    final void supportedOnlyIn2() {
        if (this.ast.apiLevel != 2) {
            throw new UnsupportedOperationException("Operation only supported in JLS2 AST");
        }
    }

    final void setParent(ASTNode parent, StructuralPropertyDescriptor property) {
        this.ast.modifying();
        this.parent = parent;
        this.location = property;
    }

    public final void delete() {
        StructuralPropertyDescriptor p = this.getLocationInParent();
        if (p == null) {
            return;
        }
        if (p.isChildProperty()) {
            this.getParent().setStructuralProperty(this.location, null);
            return;
        }
        if (p.isChildListProperty()) {
            List l = (List)this.getParent().getStructuralProperty(this.location);
            l.remove(this);
        }
    }

    static void checkNewChild(ASTNode node, ASTNode newChild, boolean cycleCheck, Class nodeType) {
        if (newChild.ast != node.ast) {
            throw new IllegalArgumentException();
        }
        if (newChild.getParent() != null) {
            throw new IllegalArgumentException();
        }
        if (cycleCheck && newChild == node.getRoot()) {
            throw new IllegalArgumentException();
        }
        Class<?> childClass = newChild.getClass();
        if (nodeType != null && !nodeType.isAssignableFrom(childClass)) {
            throw new ClassCastException();
        }
        if ((newChild.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
    }

    final void preReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        if (newChild != null) {
            ASTNode.checkNewChild(this, newChild, property.cycleRisk, null);
        }
        if (oldChild != null) {
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            if (newChild != null) {
                this.ast.preReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.preRemoveChildEvent(this, oldChild, property);
            }
            oldChild.setParent(null, null);
        } else if (newChild != null) {
            this.ast.preAddChildEvent(this, newChild, property);
        }
        if (newChild != null) {
            newChild.setParent(this, property);
        }
    }

    final void postReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if (newChild != null) {
            if (oldChild != null) {
                this.ast.postReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.postAddChildEvent(this, newChild, property);
            }
        } else {
            this.ast.postRemoveChildEvent(this, oldChild, property);
        }
    }

    final void preValueChange(SimplePropertyDescriptor property) {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.preValueChangeEvent(this, property);
        this.ast.modifying();
    }

    final void postValueChange(SimplePropertyDescriptor property) {
        this.ast.postValueChangeEvent(this, property);
    }

    final void checkModifiable() {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.modifying();
    }

    final void preLazyInit() {
        this.ast.disableEvents();
    }

    final void postLazyInit(ASTNode newChild, ChildPropertyDescriptor property) {
        newChild.setParent(this, property);
        this.ast.reenableEvents();
    }

    public final Object getProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            return null;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                return this.property2;
            }
            return null;
        }
        Map m = (Map)this.property1;
        return m.get(propertyName);
    }

    public final void setProperty(String propertyName, Object data) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            if (data == null) {
                return;
            }
            this.property1 = propertyName;
            this.property2 = data;
            return;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                this.property2 = data;
                if (data == null) {
                    this.property1 = null;
                    this.property2 = null;
                }
                return;
            }
            if (data == null) {
                return;
            }
            HashMap<Object, Object> m = new HashMap<Object, Object>(2);
            m.put(this.property1, this.property2);
            m.put(propertyName, data);
            this.property1 = m;
            this.property2 = null;
            return;
        }
        HashMap m = (HashMap)this.property1;
        if (data == null) {
            m.remove(propertyName);
            if (m.size() == 1) {
                Map.Entry[] entries = m.entrySet().toArray(new Map.Entry[1]);
                this.property1 = entries[0].getKey();
                this.property2 = entries[0].getValue();
            }
            return;
        }
        m.put(propertyName, data);
    }

    public final Map properties() {
        if (this.property1 == null) {
            return UNMODIFIABLE_EMPTY_MAP;
        }
        if (this.property1 instanceof String) {
            return Collections.singletonMap(this.property1, this.property2);
        }
        if (this.property2 == null) {
            this.property2 = Collections.unmodifiableMap((Map)this.property1);
        }
        return (Map)this.property2;
    }

    public final int getFlags() {
        return this.typeAndFlags & 0xFFFF;
    }

    public final void setFlags(int flags) {
        this.ast.modifying();
        int old = this.typeAndFlags & 0xFFFF0000;
        this.typeAndFlags = old | flags & 0xFFFF;
    }

    public final int getNodeType() {
        return this.typeAndFlags >>> 16;
    }

    private void setNodeType(int nodeType) {
        int old = this.typeAndFlags & 0xFFFF0000;
        this.typeAndFlags = old | nodeType << 16;
    }

    abstract int getNodeType0();

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return this.subtreeMatch0(matcher, other);
    }

    abstract boolean subtreeMatch0(ASTMatcher var1, Object var2);

    public static ASTNode copySubtree(AST target, ASTNode node) {
        if (node == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (target.apiLevel() != node.getAST().apiLevel()) {
            throw new UnsupportedOperationException();
        }
        ASTNode newNode = node.clone(target);
        return newNode;
    }

    public static List copySubtrees(AST target, List nodes) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(nodes.size());
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ASTNode oldNode = (ASTNode)it.next();
            ASTNode newNode = oldNode.clone(target);
            result.add(newNode);
        }
        return result;
    }

    final ASTNode clone(AST target) {
        this.ast.preCloneNodeEvent(this);
        ASTNode c = this.clone0(target);
        this.ast.postCloneNodeEvent(this, c);
        return c;
    }

    abstract ASTNode clone0(AST var1);

    public final void accept(ASTVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.preVisit(this);
        this.accept0(visitor);
        visitor.postVisit(this);
    }

    abstract void accept0(ASTVisitor var1);

    final void acceptChild(ASTVisitor visitor, ASTNode child) {
        if (child == null) {
            return;
        }
        child.accept(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void acceptChildren(ASTVisitor visitor, NodeList children) {
        NodeList.Cursor cursor = children.newCursor();
        try {
            while (cursor.hasNext()) {
                ASTNode child = (ASTNode)cursor.next();
                child.accept(visitor);
            }
        }
        finally {
            children.releaseCursor(cursor);
        }
    }

    public final int getStartPosition() {
        return this.startPosition;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setSourceRange(int startPosition, int length) {
        if (startPosition >= 0 && length < 0) {
            throw new IllegalArgumentException();
        }
        if (startPosition < 0 && length != 0) {
            throw new IllegalArgumentException();
        }
        this.checkModifiable();
        this.startPosition = startPosition;
        this.length = length;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        int p = buffer.length();
        try {
            this.appendDebugString(buffer);
        }
        catch (RuntimeException e) {
            buffer.setLength(p);
            buffer.append("!");
            buffer.append(this.standardToString());
        }
        return buffer.toString();
    }

    final String standardToString() {
        return super.toString();
    }

    void appendDebugString(StringBuffer buffer) {
        this.appendPrintString(buffer);
    }

    final void appendPrintString(StringBuffer buffer) {
        NaiveASTFlattener printer = new NaiveASTFlattener();
        this.accept(printer);
        buffer.append(printer.getResult());
    }

    static int stringSize(String string) {
        int size = 0;
        if (string != null) {
            size += 28;
            size += 12 + 2 * string.length();
        }
        return size;
    }

    public final int subtreeBytes() {
        return this.treeSize();
    }

    abstract int treeSize();

    abstract int memSize();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NodeList
    extends AbstractList {
        ArrayList store = new ArrayList(0);
        ChildListPropertyDescriptor propertyDescriptor;
        private List cursors = null;

        NodeList(ChildListPropertyDescriptor property) {
            this.propertyDescriptor = property;
        }

        public int size() {
            return this.store.size();
        }

        public Object get(int index) {
            return this.store.get(index);
        }

        public Object set(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode newChild = (ASTNode)element;
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if (oldChild == newChild) {
                return oldChild;
            }
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preReplaceChildEvent(ASTNode.this, oldChild, newChild, this.propertyDescriptor);
            ASTNode result = this.store.set(index, newChild);
            oldChild.setParent(null, null);
            newChild.setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postReplaceChildEvent(ASTNode.this, oldChild, newChild, this.propertyDescriptor);
            return result;
        }

        public void add(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode newChild = (ASTNode)element;
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preAddChildEvent(ASTNode.this, newChild, this.propertyDescriptor);
            this.store.add(index, element);
            this.updateCursors(index, 1);
            newChild.setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postAddChildEvent(ASTNode.this, newChild, this.propertyDescriptor);
        }

        public Object remove(int index) {
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.this.ast.preRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            oldChild.setParent(null, null);
            Object result = this.store.remove(index);
            this.updateCursors(index, -1);
            ASTNode.this.ast.postRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Cursor newCursor() {
            NodeList nodeList = this;
            synchronized (nodeList) {
                if (this.cursors == null) {
                    this.cursors = new ArrayList(1);
                }
                Cursor result = new Cursor();
                this.cursors.add(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseCursor(Cursor cursor) {
            NodeList nodeList = this;
            synchronized (nodeList) {
                this.cursors.remove(cursor);
                if (this.cursors.isEmpty()) {
                    this.cursors = null;
                }
            }
        }

        private void updateCursors(int index, int delta) {
            if (this.cursors == null) {
                return;
            }
            Iterator it = this.cursors.iterator();
            while (it.hasNext()) {
                Cursor c = (Cursor)it.next();
                c.update(index, delta);
            }
        }

        int memSize() {
            int result = 32;
            result += 20;
            return result += 12 + 4 * this.size();
        }

        int listSize() {
            int result = this.memSize();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ASTNode child = (ASTNode)it.next();
                result += child.treeSize();
            }
            return result;
        }

        class Cursor
        implements Iterator {
            private int position = 0;

            Cursor() {
            }

            public boolean hasNext() {
                return this.position < NodeList.this.store.size();
            }

            public Object next() {
                Object result = NodeList.this.store.get(this.position);
                ++this.position;
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            void update(int index, int delta) {
                if (this.position > index) {
                    this.position += delta;
                }
            }
        }
    }
}

