/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class CheckConditionsContext {
    private Map fCheckers = new HashMap();

    public IConditionChecker getChecker(Class clazz) {
        return (IConditionChecker)this.fCheckers.get(clazz);
    }

    public void add(IConditionChecker checker) throws CoreException {
        IConditionChecker old = this.fCheckers.put(checker.getClass(), checker);
        if (old != null) {
            this.fCheckers.put(checker.getClass(), old);
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10003, RefactoringCoreMessages.getFormattedString("CheckConditionContext.error.checker_exists", checker.getClass().toString()), null));
        }
    }

    public RefactoringStatus check(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        Collection values = this.fCheckers.values();
        pm.beginTask("", values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            IConditionChecker checker = (IConditionChecker)iter.next();
            result.merge(checker.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return result;
    }
}

