/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;

public class WidgetMethodHandler
extends AbstractHandler
implements IExecutableExtension {
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String ATTRIBUTE_ID = "id";
    protected static final Class[] NO_PARAMETERS = new Class[0];
    protected String methodName;

    public Object execute(Map parameterValuesByName) throws ExecutionException {
        Method methodToExecute = this.getMethodToExecute();
        if (methodToExecute != null) {
            try {
                Control focusControl = Display.getCurrent().getFocusControl();
                methodToExecute.invoke((Object)focusControl, null);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("An exception occurred while executing " + this.getMethodToExecute(), e.getTargetException());
            }
        }
        return null;
    }

    public Map getAttributeValuesByName() {
        HashMap<String, Boolean> attributeValuesByName = new HashMap<String, Boolean>();
        attributeValuesByName.put(ATTRIBUTE_ENABLED, this.getMethodToExecute() == null ? Boolean.FALSE : Boolean.TRUE);
        attributeValuesByName.put(ATTRIBUTE_ID, null);
        return Collections.unmodifiableMap(attributeValuesByName);
    }

    protected Method getMethodToExecute() {
        Control focusControl = Display.getCurrent().getFocusControl();
        try {
            if (focusControl != null) {
                return focusControl.getClass().getMethod(this.methodName, NO_PARAMETERS);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.methodName = data.toString();
    }
}

