/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.CompatibilityDragTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;

public abstract class PartSashContainer
extends LayoutPart
implements ILayoutContainer,
IDragOverListener {
    protected Composite parent;
    protected ControlListener resizeListener;
    protected LayoutTree root;
    protected LayoutTree unzoomRoot;
    protected WorkbenchPage page;
    boolean active = false;
    protected ArrayList children = new ArrayList();

    public PartSashContainer(String id, WorkbenchPage page) {
        super(id);
        this.page = page;
        this.resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PartSashContainer.this.resizeSashes(PartSashContainer.this.parent.getClientArea());
            }
        };
    }

    private PartPane[] getVisibleParts(LayoutPart pane) {
        if (pane instanceof PartPane) {
            return new PartPane[]{(PartPane)pane};
        }
        if (pane instanceof PartStack) {
            PartStack stack = (PartStack)pane;
            LayoutPart[] children = stack.getChildren();
            ArrayList<LayoutPart> result = new ArrayList<LayoutPart>(children.length);
            for (int idx = 0; idx < children.length; ++idx) {
                LayoutPart next = children[idx];
                if (!(next instanceof PartPane)) continue;
                result.add(next);
            }
            return result.toArray(new PartPane[result.size()]);
        }
        return new PartPane[0];
    }

    public void findSashes(LayoutPart pane, PartPane.Sashes sashes) {
        if (this.root == null) {
            return;
        }
        LayoutTree part = this.root.find(pane);
        if (part == null) {
            return;
        }
        part.findSashes(sashes);
    }

    public void add(LayoutPart child) {
        if (child == null) {
            return;
        }
        this.addEnhanced(child, 131072, 0.5f, this.findBottomRight());
    }

    void addEnhanced(LayoutPart child, int swtDirectionConstant, float ratioForNewPart, LayoutPart relative) {
        int relativePosition = PageLayout.swtConstantToLayoutPosition(swtDirectionConstant);
        float ratioForUpperLeftPart = relativePosition == 2 || relativePosition == 4 ? 1.0f - ratioForNewPart : ratioForNewPart;
        this.add(child, relativePosition, ratioForUpperLeftPart, relative);
    }

    public void add(LayoutPart child, int relationship, float ratio, LayoutPart relative) {
        Rectangle bounds;
        boolean isHorizontal = relationship == 1 || relationship == 2;
        LayoutTree node = null;
        if (this.root != null && relative != null) {
            node = this.root.find(relative);
        }
        if (this.getParent() == null) {
            Composite control = this.getPage().getClientComposite();
            bounds = control != null && !control.isDisposed() ? control.getBounds() : new Rectangle(0, 0, 800, 600);
            bounds.x = 0;
            bounds.y = 0;
        } else {
            bounds = this.getBounds();
        }
        int totalSize = PartSashContainer.measureTree(bounds, node, isHorizontal);
        int left = (int)((float)totalSize * ratio);
        int right = totalSize - left;
        this.add(child, relationship, left, right, relative);
    }

    static int measureTree(Rectangle outerBounds, LayoutTree toMeasure, boolean horizontal) {
        if (toMeasure == null) {
            return Geometry.getDimension((Rectangle)outerBounds, (boolean)horizontal);
        }
        LayoutTreeNode parent = toMeasure.getParent();
        if (parent == null) {
            return Geometry.getDimension((Rectangle)outerBounds, (boolean)horizontal);
        }
        if (parent.getSash().isHorizontal() == horizontal) {
            return PartSashContainer.measureTree(outerBounds, parent, horizontal);
        }
        boolean isLeft = parent.isLeftChild(toMeasure);
        LayoutTree otherChild = parent.getChild(!isLeft);
        if (otherChild.isVisible()) {
            int left = parent.getSash().getLeft();
            int right = parent.getSash().getRight();
            int childSize = isLeft ? left : right;
            int bias = parent.getCompressionBias();
            if (isLeft) {
                bias = -bias;
            }
            if (bias == 1) {
                return childSize;
            }
            if (bias == -1) {
                return PartSashContainer.measureTree(outerBounds, parent, horizontal) - (left + right - childSize);
            }
            return PartSashContainer.measureTree(outerBounds, parent, horizontal) * childSize / (left + right);
        }
        return PartSashContainer.measureTree(outerBounds, parent, horizontal);
    }

    protected void addChild(RelationshipInfo info) {
        LayoutPart child = info.part;
        this.children.add(child);
        if (this.root == null) {
            this.root = new LayoutTree(child);
        } else {
            int vertical = info.relationship == 1 || info.relationship == 2 ? 512 : 256;
            boolean left = info.relationship == 1 || info.relationship == 3;
            LayoutPartSash sash = new LayoutPartSash(this, vertical);
            sash.setSizes(info.left, info.right);
            if (this.parent != null && !(child instanceof PartPlaceholder)) {
                sash.createControl(this.parent);
            }
            this.root = this.root.insert(child, left, sash, info.relative);
        }
        this.childAdded(child);
        if (this.active) {
            child.createControl(this.parent);
            child.setVisible(true);
            child.setContainer(this);
            this.resizeSashes(this.parent.getClientArea());
        }
    }

    void addChildForPlaceholder(LayoutPart child, LayoutPart placeholder) {
        RelationshipInfo newRelationshipInfo = new RelationshipInfo();
        newRelationshipInfo.part = child;
        if (this.root != null) {
            newRelationshipInfo.relationship = 2;
            newRelationshipInfo.relative = this.root.findBottomRight();
            newRelationshipInfo.left = 200;
            newRelationshipInfo.right = 200;
        }
        RelationshipInfo[] relationships = this.computeRelation();
        for (int i = 0; i < relationships.length; ++i) {
            RelationshipInfo info = relationships[i];
            if (info.part != placeholder) continue;
            newRelationshipInfo.left = info.left;
            newRelationshipInfo.right = info.right;
            newRelationshipInfo.relationship = info.relationship;
            newRelationshipInfo.relative = info.relative;
        }
        this.addChild(newRelationshipInfo);
        if (this.root != null) {
            this.root.updateSashes(this.parent);
        }
        this.resizeSashes(this.parent.getClientArea());
    }

    public boolean allowsBorder() {
        return true;
    }

    protected abstract void childAdded(LayoutPart var1);

    protected abstract void childRemoved(LayoutPart var1);

    public RelationshipInfo[] computeRelation() {
        LayoutTree treeRoot = this.root;
        if (this.isZoomed()) {
            treeRoot = this.unzoomRoot;
        }
        ArrayList<RelationshipInfo> list = new ArrayList<RelationshipInfo>();
        if (treeRoot == null) {
            return new RelationshipInfo[0];
        }
        RelationshipInfo r = new RelationshipInfo();
        r.part = treeRoot.computeRelation(list);
        list.add(0, r);
        RelationshipInfo[] result = new RelationshipInfo[list.size()];
        list.toArray(result);
        return result;
    }

    public void createControl(Composite parentWidget) {
        if (this.active) {
            return;
        }
        this.parent = this.createParent(parentWidget);
        this.parent.addControlListener(this.resizeListener);
        DragUtil.addDragTarget((Control)this.parent, this);
        DragUtil.addDragTarget((Control)this.parent.getShell(), this);
        ArrayList children = (ArrayList)this.children.clone();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            LayoutPart child = (LayoutPart)children.get(i);
            child.setContainer(this);
            child.createControl(this.parent);
        }
        if (this.root != null) {
            this.root.updateSashes(this.parent);
        }
        this.active = true;
        this.resizeSashes(this.parent.getClientArea());
    }

    protected abstract Composite createParent(Composite var1);

    public void dispose() {
        if (!this.active) {
            return;
        }
        DragUtil.removeDragTarget((Control)this.parent, this);
        DragUtil.removeDragTarget((Control)this.parent.getShell(), this);
        if (this.resizeListener != null && this.parent != null) {
            this.parent.removeControlListener(this.resizeListener);
        }
        this.resizeSashes(new Rectangle(-200, -200, 0, 0));
        if (this.children != null) {
            int length = this.children.size();
            for (int i = 0; i < length; ++i) {
                LayoutPart child = (LayoutPart)this.children.get(i);
                child.setContainer(null);
                if (!(child instanceof ViewStack)) continue;
                child.dispose();
            }
        }
        this.disposeParent();
        this.parent = null;
        this.active = false;
    }

    protected abstract void disposeParent();

    public void disposeSashes() {
        if (this.root != null) {
            this.root.disposeSashes();
        }
    }

    public LayoutPart findBottomRight() {
        if (this.root == null) {
            return null;
        }
        return this.root.findBottomRight();
    }

    public Rectangle getBounds() {
        return this.parent.getBounds();
    }

    public int getMinimumHeight() {
        return this.getLayoutTree().getMinimumHeight();
    }

    public int getMinimumWidth() {
        return this.getLayoutTree().getMinimumWidth();
    }

    public LayoutPart[] getChildren() {
        LayoutPart[] result = new LayoutPart[this.children.size()];
        this.children.toArray(result);
        return result;
    }

    public Control getControl() {
        return this.parent;
    }

    public LayoutTree getLayoutTree() {
        return this.root;
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    public Composite getParent() {
        return this.parent;
    }

    protected boolean isChild(LayoutPart part) {
        return this.children.indexOf(part) >= 0;
    }

    private boolean isRelationshipCompatible(int relationship, boolean isVertical) {
        if (isVertical) {
            return relationship == 2 || relationship == 1;
        }
        return relationship == 3 || relationship == 4;
    }

    public boolean isZoomed() {
        return this.unzoomRoot != null;
    }

    public void remove(LayoutPart child) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (!this.isChild(child)) {
            return;
        }
        this.children.remove(child);
        if (this.root != null) {
            this.root = this.root.remove(child);
            if (this.root != null) {
                this.root.updateSashes(this.parent);
            }
        }
        this.childRemoved(child);
        if (this.active) {
            child.setVisible(false);
            child.setContainer(null);
            this.resizeSashes(this.parent.getClientArea());
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (!this.isChild(oldChild)) {
            return;
        }
        LayoutTree leaf = null;
        if (this.root != null) {
            leaf = this.root.find(oldChild);
        }
        if (leaf == null) {
            return;
        }
        this.children.remove(oldChild);
        this.children.add(newChild);
        this.childAdded(newChild);
        leaf.setPart(newChild);
        if (this.root != null) {
            this.root.updateSashes(this.parent);
        }
        this.childRemoved(oldChild);
        if (this.active) {
            oldChild.setVisible(false);
            oldChild.setContainer(null);
            newChild.createControl(this.parent);
            newChild.setContainer(this);
            newChild.setVisible(true);
            this.resizeSashes(this.parent.getClientArea());
        }
    }

    private void resizeSashes(Rectangle parentSize) {
        if (!this.active) {
            return;
        }
        if (this.root != null) {
            this.root.setBounds(parentSize);
        }
    }

    public void setBounds(Rectangle r) {
        this.parent.setBounds(r);
    }

    public void zoomIn(LayoutPart part) {
        if (this.unzoomRoot != null) {
            return;
        }
        Rectangle oldBounds = this.root.getBounds();
        this.root.setBounds(new Rectangle(0, 0, 0, 0));
        this.unzoomRoot = this.root;
        this.root = new LayoutTree(part);
        this.root.setBounds(oldBounds);
    }

    public void zoomOut() {
        if (this.unzoomRoot == null) {
            return;
        }
        Rectangle oldBounds = this.root.getBounds();
        this.root.setBounds(new Rectangle(0, 0, 0, 0));
        this.root = this.unzoomRoot;
        this.root.setBounds(oldBounds);
        this.unzoomRoot = null;
    }

    public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
        ILayoutContainer sourceContainer;
        if (!(draggedObject instanceof LayoutPart)) {
            return null;
        }
        LayoutPart sourcePart = (LayoutPart)draggedObject;
        if (!this.isStackType(sourcePart) && !this.isPaneType(sourcePart)) {
            return null;
        }
        if (sourcePart.getWorkbenchWindow() != this.getWorkbenchWindow()) {
            return null;
        }
        Rectangle containerBounds = DragUtil.getDisplayBounds((Control)this.parent);
        LayoutPart targetPart = null;
        ILayoutContainer iLayoutContainer = sourceContainer = this.isStackType(sourcePart) ? (ILayoutContainer)((Object)sourcePart) : sourcePart.getContainer();
        if (containerBounds.contains(position)) {
            if (this.root != null) {
                targetPart = this.root.findPart(this.parent.toControl(position));
            }
            if (targetPart != null) {
                Control targetControl = targetPart.getControl();
                int side = CompatibilityDragTarget.getRelativePosition(targetControl, position);
                Rectangle targetBounds = DragUtil.getDisplayBounds(targetControl);
                if (side == -1 || side == 0x1000000 && !this.isStackType(targetPart)) {
                    side = Geometry.getClosestSide((Rectangle)targetBounds, (Point)position);
                }
                boolean pointlessDrop = this.isZoomed();
                if (sourcePart == targetPart) {
                    pointlessDrop = true;
                }
                if (sourceContainer != null && sourceContainer == targetPart && this.getVisibleChildrenCount(sourceContainer) <= 1) {
                    pointlessDrop = true;
                }
                if (side == 0x1000000 && sourcePart.getContainer() == targetPart) {
                    pointlessDrop = true;
                }
                int cursor = side;
                if (pointlessDrop) {
                    side = 0;
                    cursor = 0x1000000;
                }
                return new SashContainerDropTarget(sourcePart, side, cursor, targetPart);
            }
        } else {
            int side = Geometry.getClosestSide((Rectangle)containerBounds, (Point)position);
            boolean pointlessDrop = this.isZoomed();
            if ((this.isStackType(sourcePart) || sourcePart.getContainer() != null && this.isPaneType(sourcePart) && this.getVisibleChildrenCount(sourcePart.getContainer()) <= 1) && (this.root == null || this.getVisibleChildrenCount(this) <= 1)) {
                pointlessDrop = true;
            }
            int cursor = Geometry.getOppositeSide((int)side);
            if (pointlessDrop) {
                side = 0;
            }
            return new SashContainerDropTarget(sourcePart, side, cursor, null);
        }
        return null;
    }

    public abstract boolean isStackType(LayoutPart var1);

    public abstract boolean isPaneType(LayoutPart var1);

    protected void dropObject(PartPane[] toDrop, LayoutPart visiblePart, LayoutPart targetPart, int side) {
        this.getControl().setRedraw(false);
        if (side == 0x1000000) {
            if (this.isStackType(targetPart)) {
                PartStack stack = (PartStack)targetPart;
                for (int idx = 0; idx < toDrop.length; ++idx) {
                    PartPane next = toDrop[idx];
                    this.stack(next, stack);
                }
            }
        } else {
            PartStack newPart = this.createStack();
            for (int idx = 0; idx < toDrop.length; ++idx) {
                PartPane next = toDrop[idx];
                this.stack(next, newPart);
            }
            this.addEnhanced(newPart, side, this.getDockingRatio(newPart, targetPart), targetPart);
        }
        this.setVisiblePart(visiblePart.getContainer(), visiblePart);
        this.getControl().setRedraw(true);
        visiblePart.setFocus();
    }

    protected abstract PartStack createStack();

    public void stack(LayoutPart newPart, PartStack container) {
        this.getControl().setRedraw(false);
        this.derefPart(newPart);
        newPart.reparent(this.getParent());
        container.add(newPart);
        this.getControl().setRedraw(true);
    }

    protected abstract void setVisiblePart(ILayoutContainer var1, LayoutPart var2);

    protected abstract LayoutPart getVisiblePart(ILayoutContainer var1);

    protected void derefPart(LayoutPart sourcePart) {
        PartStack stack;
        ILayoutContainer container = sourcePart.getContainer();
        if (container != null) {
            container.remove(sourcePart);
        }
        if (container instanceof LayoutPart && this.isStackType((LayoutPart)((Object)container)) && (stack = (PartStack)container).getChildren().length == 0) {
            this.remove(stack);
            stack.dispose();
        }
    }

    protected int getVisibleChildrenCount(ILayoutContainer container) {
        if (container == null) {
            return 0;
        }
        LayoutPart[] children = container.getChildren();
        int count = 0;
        for (int idx = 0; idx < children.length; ++idx) {
            if (children[idx] instanceof PartPlaceholder) continue;
            ++count;
        }
        return count;
    }

    protected float getDockingRatio(LayoutPart dragged, LayoutPart target) {
        return 0.5f;
    }

    public void describeLayout(StringBuffer buf) {
        if (this.root == null) {
            return;
        }
        if (this.isZoomed()) {
            buf.append("zoomed ");
            this.root.describeLayout(buf);
        } else {
            buf.append("layout ");
            this.root.describeLayout(buf);
        }
    }

    void add(LayoutPart child, int relationship, int left, int right, LayoutPart relative) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (child == null) {
            return;
        }
        if (relative != null && !this.isChild(relative)) {
            return;
        }
        if (relationship < 1 || relationship > 4) {
            relationship = 1;
        }
        RelationshipInfo info = new RelationshipInfo();
        info.part = child;
        info.relationship = relationship;
        info.left = left;
        info.right = right;
        info.relative = relative;
        this.addChild(info);
    }

    public void testInvariants() {
        super.testInvariants();
        LayoutPart[] children = this.getChildren();
        for (int idx = 0; idx < children.length; ++idx) {
            children[idx].testInvariants();
        }
    }

    private class SashContainerDropTarget
    extends AbstractDropTarget {
        private int side;
        private int cursor;
        private LayoutPart targetPart;
        private LayoutPart sourcePart;

        public SashContainerDropTarget(LayoutPart sourcePart, int side, int cursor, LayoutPart targetPart) {
            this.side = side;
            this.targetPart = targetPart;
            this.sourcePart = sourcePart;
            this.cursor = cursor;
        }

        public void drop() {
            if (this.side != 0) {
                LayoutPart visiblePart = this.sourcePart;
                if (this.sourcePart instanceof PartStack) {
                    visiblePart = PartSashContainer.this.getVisiblePart((PartStack)this.sourcePart);
                }
                PartSashContainer.this.dropObject(PartSashContainer.this.getVisibleParts(this.sourcePart), visiblePart, this.targetPart, this.side);
            }
        }

        public Cursor getCursor() {
            return DragCursors.getCursor(DragCursors.positionToDragCursor(this.cursor));
        }

        public Rectangle getSnapRectangle() {
            Rectangle targetBounds = this.targetPart != null ? DragUtil.getDisplayBounds(this.targetPart.getControl()) : DragUtil.getDisplayBounds((Control)PartSashContainer.this.getParent());
            if (this.side == 0x1000000 || this.side == 0) {
                return targetBounds;
            }
            int distance = Geometry.getDimension((Rectangle)targetBounds, (!Geometry.isHorizontal((int)this.side) ? 1 : 0) != 0);
            return Geometry.getExtrudedEdge((Rectangle)targetBounds, (int)((int)((float)distance * PartSashContainer.this.getDockingRatio(this.sourcePart, this.targetPart))), (int)this.side);
        }
    }

    protected static class RelationshipInfo {
        protected LayoutPart part;
        protected LayoutPart relative;
        protected int relationship;
        protected int left;
        protected int right;

        protected RelationshipInfo() {
        }

        public float getRatio() {
            int total = this.left + this.right;
            if (total > 0) {
                return (float)this.left / (float)total;
            }
            return 0.5f;
        }
    }
}

