/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TagetLocationSelectionDialog
extends SelectionDialog {
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Label statusMessageLabel;
    private Button browseButton;
    private boolean useDefaults = true;
    private IProject[] targetProjects;
    private String newProjectName;
    private String targetLocation;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public TagetLocationSelectionDialog(Shell parentShell, String title, IProject targetProject) {
        this(parentShell, title, new IProject[]{targetProject});
    }

    public TagetLocationSelectionDialog(Shell parentShell, String title, IProject[] targetProjects) {
        super(parentShell);
        this.setTitle(title);
        this.targetProjects = targetProjects;
        if (targetProjects.length == 1) {
            this.newProjectName = targetProjects[0].getName();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        if (this.isSingleCheckout()) {
            this.createProjectNameGroup(composite);
        }
        this.createProjectLocationGroup(composite);
        this.statusMessageLabel = new Label(composite, 0);
        this.statusMessageLabel.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Policy.bind("TargetLocationSelectionDialog.projectNameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setText(this.getNewProjectName());
        this.projectNameField.selectAll();
        this.createNameListener();
    }

    private void createNameListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TagetLocationSelectionDialog.this.newProjectName = TagetLocationSelectionDialog.this.projectNameField.getText();
                TagetLocationSelectionDialog.this.setLocationForSelection(false);
                TagetLocationSelectionDialog.this.applyValidationResult(TagetLocationSelectionDialog.this.checkValid());
            }
        };
        this.projectNameField.addListener(24, listener);
    }

    private void setLocationForSelection(boolean changed) {
        if (this.useDefaults) {
            IPath defaultPath = null;
            if (this.isSingleCheckout()) {
                try {
                    defaultPath = this.getSingleProject().getDescription().getLocation();
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (defaultPath == null) {
                    defaultPath = Platform.getLocation().append(this.getSingleProject().getName());
                }
            } else {
                defaultPath = Platform.getLocation();
            }
            this.locationPathField.setText(defaultPath.toOSString());
            this.targetLocation = null;
        } else if (changed) {
            IPath location = null;
            try {
                location = this.targetProjects[0].getDescription().getLocation();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (location == null) {
                this.targetLocation = null;
                this.locationPathField.setText("");
            } else {
                this.targetLocation = this.isSingleCheckout() ? location.toOSString() : location.removeLastSegments(1).toOSString();
                this.locationPathField.setText(this.targetLocation);
            }
        }
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText(Policy.bind("TargetLocationSelectionDialog.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagetLocationSelectionDialog.this.useDefaults = useDefaultsButton.getSelection();
                TagetLocationSelectionDialog.this.browseButton.setEnabled(!TagetLocationSelectionDialog.this.useDefaults);
                TagetLocationSelectionDialog.this.locationPathField.setEnabled(!TagetLocationSelectionDialog.this.useDefaults);
                TagetLocationSelectionDialog.this.locationLabel.setEnabled(!TagetLocationSelectionDialog.this.useDefaults);
                TagetLocationSelectionDialog.this.setLocationForSelection(true);
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private Composite createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        if (this.isSingleCheckout()) {
            this.locationLabel.setText(Policy.bind("TargetLocationSelectionDialog.locationLabel"));
        } else {
            this.locationLabel.setText(Policy.bind("TargetLocationSelectionDialog.parentDirectoryLabel"));
        }
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(Policy.bind("TargetLocationSelectionDialog.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TagetLocationSelectionDialog.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.setButtonLayoutData(this.browseButton);
        this.setLocationForSelection(true);
        this.createLocationListener();
        return projectGroup;
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        if (this.isSingleCheckout()) {
            dialog.setMessage(Policy.bind("TargetLocationSelectionDialog.messageForSingle", this.newProjectName));
        } else {
            dialog.setMessage(Policy.bind("TargetLocationSelectionDialog.messageForMulti", new Integer(this.targetProjects.length).toString()));
        }
        String dirName = this.locationPathField.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            if (this.targetProjects.length == 1) {
                this.locationPathField.setText(new Path(selectedDirectory).append(this.newProjectName).toOSString());
            } else {
                this.locationPathField.setText(new Path(selectedDirectory).toOSString());
            }
        }
        this.targetLocation = this.locationPathField.getText();
    }

    private boolean isSingleCheckout() {
        return this.targetProjects.length == 1;
    }

    private IProject getSingleProject() {
        if (this.newProjectName == null || this.newProjectName.length() == 0 || this.targetProjects[0].getName().equals(this.newProjectName)) {
            return this.targetProjects[0];
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.newProjectName);
    }

    private void createLocationListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TagetLocationSelectionDialog.this.applyValidationResult(TagetLocationSelectionDialog.this.checkValid());
            }
        };
        this.locationPathField.addListener(24, listener);
    }

    private void applyValidationResult(String errorMsg) {
        if (errorMsg == null) {
            this.statusMessageLabel.setText("");
            this.getOkButton().setEnabled(true);
        } else {
            this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.statusMessageLabel.getDisplay()));
            this.statusMessageLabel.setText(errorMsg);
            this.getOkButton().setEnabled(false);
        }
    }

    private String checkValid() {
        String valid;
        if (this.isSingleCheckout() && (valid = this.checkValidName()) != null) {
            return valid;
        }
        return this.checkValidLocation();
    }

    private String checkValidLocation() {
        if (this.useDefaults) {
            this.targetLocation = null;
            return null;
        }
        this.targetLocation = this.locationPathField.getText();
        if (this.targetLocation.equals("")) {
            return Policy.bind("TagetLocationSelectionDialog.locationEmpty");
        }
        Path path = new Path("");
        if (!path.isValidPath(this.targetLocation)) {
            return Policy.bind("TagetLocationSelectionDialog.invalidLocation");
        }
        if (this.isSingleCheckout()) {
            IStatus locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(this.getSingleProject(), (IPath)new Path(this.targetLocation));
            if (!locationStatus.isOK()) {
                return locationStatus.getMessage();
            }
        } else {
            for (int i = 0; i < this.targetProjects.length; ++i) {
                ResourcesPlugin.getWorkspace().validateProjectLocation(this.targetProjects[i], new Path(this.targetLocation).append(this.targetProjects[i].getName()));
            }
        }
        return null;
    }

    private String checkValidName() {
        this.newProjectName = this.projectNameField.getText();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.newProjectName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus.getMessage();
        }
        return null;
    }

    public String getNewProjectName() {
        return this.newProjectName;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }
}

