/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlatformConfigurationUtils {
    private static final String PLUGIN_PATH = ".plugin-path";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = PlatformConfigurationUtils.readPluginPath(input);
            }
            finally {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException e) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException e) {}
            }
        }
        return result.toArray(new URL[result.size()]);
    }
}

