/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertSelectionAction
extends QuickDiffRestoreAction {
    private int fStartLine;
    private int fEndLine;

    public RevertSelectionAction(ITextEditor editor) {
        super(QuickDiffMessages.getResourceBundle(), "RevertSelectionAction.", editor);
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        ITextSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        this.fStartLine = selection.getStartLine();
        this.fEndLine = selection.getEndLine();
        IVerticalRulerInfo ruler = this.getRuler();
        if (ruler == null) {
            return;
        }
        int activityLine = ruler.getLineOfLastMouseButtonActivity();
        if (activityLine < this.fStartLine || activityLine > this.fEndLine + 1) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return;
        }
        if (this.fEndLine > this.fStartLine) {
            for (int i = this.fStartLine; i <= this.fEndLine; ++i) {
                ILineDiffInfo info = differ.getLineInfo(i);
                if (info == null || !info.hasChanges()) continue;
                this.setEnabled(true);
            }
        }
    }

    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.revertSelection(this.fStartLine, this.fEndLine - this.fStartLine + 1);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

