/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends SubRoutineStatement {
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    private boolean isSubRoutineEscaping = false;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean tryBlockExit;
    boolean[] catchExits;
    public int[] preserveExceptionHandler;
    Label subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    public static final char[] SecretReturnName = " returnAddress".toCharArray();
    public static final char[] SecretAnyHandlerName = " anyExceptionHandler".toCharArray();
    public static final char[] SecretLocalDeclarationName = " returnValue".toCharArray();
    int preTryInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo tryInfo;
        UnconditionalFlowInfo subInfo;
        FinallyFlowContext finallyContext;
        InsideSubRoutineFlowContext insideSubContext;
        this.preTryInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (this.subRoutineStartLabel == null) {
            insideSubContext = null;
            finallyContext = null;
            subInfo = null;
        } else {
            insideSubContext = new InsideSubRoutineFlowContext(flowContext, this);
            finallyContext = new FinallyFlowContext(flowContext, this.finallyBlock);
            subInfo = this.finallyBlock.analyseCode(currentScope, finallyContext, flowInfo.copy()).unconditionalInits();
            if (subInfo == FlowInfo.DEAD_END) {
                this.isSubRoutineEscaping = true;
                this.scope.problemReporter().finallyMustCompleteNormally(this.finallyBlock);
            }
            this.subRoutineInits = subInfo;
        }
        ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(insideSubContext == null ? flowContext : insideSubContext, this.tryBlock, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        if (this.tryBlock.isEmptyBlock()) {
            tryInfo = flowInfo;
            this.tryBlockExit = false;
        } else {
            tryInfo = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
            this.tryBlockExit = !tryInfo.isReachable();
        }
        handlingContext.complainIfUnusedExceptionHandlers(this.scope, this);
        if (this.catchArguments != null) {
            int catchCount = this.catchBlocks.length;
            this.catchExits = new boolean[catchCount];
            for (int i = 0; i < catchCount; ++i) {
                FlowInfo catchInfo = flowInfo.copy().unconditionalInits().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i]).unconditionalInits()).addPotentialInitializationsFrom(tryInfo.unconditionalInits()).addPotentialInitializationsFrom(handlingContext.initsOnReturn);
                catchInfo.markAsDefinitelyAssigned(this.catchArguments[i].binding);
                if (this.tryBlock.statements == null) {
                    catchInfo.setReachMode(1);
                }
                catchInfo = this.catchBlocks[i].analyseCode(currentScope, insideSubContext == null ? flowContext : insideSubContext, catchInfo);
                this.catchExits[i] = !catchInfo.isReachable();
                tryInfo = tryInfo.mergedWith(catchInfo.unconditionalInits());
            }
        }
        if (this.subRoutineStartLabel == null) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(tryInfo);
            return tryInfo;
        }
        finallyContext.complainOnRedundantFinalAssignments(tryInfo.isReachable() ? tryInfo.addPotentialInitializationsFrom(insideSubContext.initsOnReturn) : insideSubContext.initsOnReturn, currentScope);
        if (subInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(subInfo);
            return subInfo;
        }
        FlowInfo mergedInfo = tryInfo.addInitializationsFrom(subInfo);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public boolean isSubRoutineEscaping() {
        return this.isSubRoutineEscaping;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean tryBlockHasSomeCode;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.anyExceptionLabelsCount > 0) {
            this.anyExceptionLabels = NO_EXCEPTION_HANDLER;
            this.anyExceptionLabelsCount = 0;
        }
        int pc = codeStream.position;
        boolean NO_FINALLY = false;
        boolean FINALLY_SUBROUTINE = true;
        int FINALLY_DOES_NOT_COMPLETE = 2;
        int FINALLY_MUST_BE_INLINED = 3;
        int finallyMode = this.subRoutineStartLabel == null ? 0 : (this.isSubRoutineEscaping ? 2 : (this.scope.environment().options.inlineJsrBytecode ? 3 : 1));
        boolean requiresNaturalExit = false;
        int maxCatches = this.catchArguments == null ? 0 : this.catchArguments.length;
        ExceptionLabel[] exceptionLabels = new ExceptionLabel[maxCatches];
        for (int i = 0; i < maxCatches; ++i) {
            exceptionLabels[i] = new ExceptionLabel(codeStream, this.catchArguments[i].binding.type);
        }
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.initialize(codeStream);
            this.enterAnyExceptionHandler(codeStream);
        }
        this.tryBlock.generateCode(this.scope, codeStream);
        boolean bl = tryBlockHasSomeCode = codeStream.position != pc;
        if (tryBlockHasSomeCode) {
            int i;
            Label naturalExitLabel = new Label(codeStream);
            if (!this.tryBlockExit) {
                int position = codeStream.position;
                switch (finallyMode) {
                    case 1: 
                    case 3: {
                        requiresNaturalExit = true;
                    }
                    case 0: {
                        codeStream.goto_(naturalExitLabel);
                        break;
                    }
                    case 2: {
                        codeStream.goto_(this.subRoutineStartLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(position);
            }
            for (i = 0; i < maxCatches; ++i) {
                exceptionLabels[i].placeEnd();
            }
            if (this.catchArguments == null) {
                this.exitAnyExceptionHandler();
            } else {
                block21: for (i = 0; i < maxCatches; ++i) {
                    if (this.preTryInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                    }
                    exceptionLabels[i].place();
                    codeStream.incrStackSize(1);
                    int varPC = codeStream.position;
                    LocalVariableBinding catchVar = this.catchArguments[i].binding;
                    if (catchVar.resolvedPosition != -1) {
                        codeStream.store(catchVar, false);
                        catchVar.recordInitializationStartPC(codeStream.position);
                        codeStream.addVisibleLocalVariable(catchVar);
                    } else {
                        codeStream.pop();
                    }
                    codeStream.recordPositionsFrom(varPC, this.catchArguments[i].sourceStart);
                    this.catchBlocks[i].generateCode(this.scope, codeStream);
                    if (i == maxCatches - 1) {
                        this.exitAnyExceptionHandler();
                    }
                    if (this.catchExits[i]) continue;
                    switch (finallyMode) {
                        case 1: 
                        case 3: {
                            requiresNaturalExit = true;
                        }
                        case 0: {
                            codeStream.goto_(naturalExitLabel);
                            continue block21;
                        }
                        case 2: {
                            codeStream.goto_(this.subRoutineStartLabel);
                        }
                    }
                }
            }
            ExceptionLabel naturalExitExceptionHandler = finallyMode == 1 && requiresNaturalExit ? this.enterAnyExceptionHandler(codeStream) : null;
            int finallySequenceStartPC = codeStream.position;
            if (this.subRoutineStartLabel != null) {
                int position;
                this.placeAllAnyExceptionHandlers();
                if (this.preTryInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                }
                codeStream.incrStackSize(1);
                switch (finallyMode) {
                    case 1: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.jsr(this.subRoutineStartLabel);
                        codeStream.load(this.anyExceptionVariable);
                        codeStream.athrow();
                        this.subRoutineStartLabel.place();
                        codeStream.incrStackSize(1);
                        codeStream.store(this.returnAddressVariable, false);
                        codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                        position = codeStream.position;
                        codeStream.ret(this.returnAddressVariable.resolvedPosition);
                        codeStream.updateLastRecordedEndPC(position);
                        codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 3: {
                        codeStream.store(this.anyExceptionVariable, false);
                        this.finallyBlock.generateCode(currentScope, codeStream);
                        codeStream.load(this.anyExceptionVariable);
                        codeStream.athrow();
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                        break;
                    }
                    case 2: {
                        codeStream.pop();
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                    }
                }
                naturalExitLabel.place();
                if (requiresNaturalExit) {
                    switch (finallyMode) {
                        case 1: {
                            position = codeStream.position;
                            naturalExitExceptionHandler.placeStart();
                            codeStream.jsr(this.subRoutineStartLabel);
                            naturalExitExceptionHandler.placeEnd();
                            codeStream.recordPositionsFrom(position, this.finallyBlock.sourceStart);
                            break;
                        }
                        case 3: {
                            if (this.preTryInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                            }
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            break;
                        }
                    }
                }
            } else {
                naturalExitLabel.place();
            }
        } else if (this.subRoutineStartLabel != null) {
            this.finallyBlock.generateCode(this.scope, codeStream);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateSubRoutineInvocation(BlockScope currentScope, CodeStream codeStream) {
        if (this.isSubRoutineEscaping) {
            codeStream.goto_(this.subRoutineStartLabel);
        } else if (currentScope.environment().options.inlineJsrBytecode) {
            this.finallyBlock.generateCode(currentScope, codeStream);
        } else {
            codeStream.jsr(this.subRoutineStartLabel);
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        TryStatement.printIndent(indent, output).append("try \n");
        this.tryBlock.printStatement(indent + 1, output);
        if (this.catchBlocks != null) {
            for (int i = 0; i < this.catchBlocks.length; ++i) {
                output.append('\n');
                TryStatement.printIndent(indent, output).append("catch (");
                this.catchArguments[i].print(0, output).append(") ");
                this.catchBlocks[i].printStatement(indent + 1, output);
            }
        }
        if (this.finallyBlock != null) {
            output.append('\n');
            TryStatement.printIndent(indent, output).append("finally\n");
            this.finallyBlock.printStatement(indent + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        BlockScope tryScope = new BlockScope(this.scope);
        BlockScope finallyScope = null;
        if (this.finallyBlock != null) {
            if (this.finallyBlock.isEmptyBlock()) {
                if ((this.finallyBlock.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.finallyBlock.sourceStart, this.finallyBlock.sourceEnd);
                }
            } else {
                MethodBinding methodBinding;
                finallyScope = new BlockScope(this.scope, false);
                MethodScope methodScope = this.scope.methodScope();
                if (!upperScope.environment().options.inlineJsrBytecode) {
                    this.returnAddressVariable = new LocalVariableBinding(SecretReturnName, (TypeBinding)upperScope.getJavaLangObject(), 0, false);
                    finallyScope.addLocalVariable(this.returnAddressVariable);
                    this.returnAddressVariable.constant = NotAConstant;
                }
                this.subRoutineStartLabel = new Label();
                this.anyExceptionVariable = new LocalVariableBinding(SecretAnyHandlerName, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
                finallyScope.addLocalVariable(this.anyExceptionVariable);
                this.anyExceptionVariable.constant = NotAConstant;
                if (!methodScope.isInsideInitializer() && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                    TypeBinding methodReturnType = methodBinding.returnType;
                    if (methodReturnType.id != 6) {
                        this.secretReturnValue = new LocalVariableBinding(SecretLocalDeclarationName, methodReturnType, 0, false);
                        finallyScope.addLocalVariable(this.secretReturnValue);
                        this.secretReturnValue.constant = NotAConstant;
                    }
                }
                this.finallyBlock.resolveUsing(finallyScope);
                finallyScope.shiftScopes = new BlockScope[this.catchArguments == null ? 1 : this.catchArguments.length + 1];
                finallyScope.shiftScopes[0] = tryScope;
            }
        }
        this.tryBlock.resolveUsing(tryScope);
        if (this.catchBlocks != null) {
            int i;
            int length = this.catchArguments.length;
            TypeBinding[] argumentTypes = new TypeBinding[length];
            for (i = 0; i < length; ++i) {
                BlockScope catchScope = new BlockScope(this.scope);
                if (finallyScope != null) {
                    finallyScope.shiftScopes[i + 1] = catchScope;
                }
                if ((argumentTypes[i] = this.catchArguments[i].resolveForCatch(catchScope)) == null) {
                    return;
                }
                this.catchBlocks[i].resolveUsing(catchScope);
            }
            this.caughtExceptionTypes = new ReferenceBinding[length];
            for (i = 0; i < length; ++i) {
                this.caughtExceptionTypes[i] = (ReferenceBinding)argumentTypes[i];
                for (int j = 0; j < i; ++j) {
                    if (!this.caughtExceptionTypes[i].isCompatibleWith(argumentTypes[j])) continue;
                    this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this, this.caughtExceptionTypes[i], i, argumentTypes[j]);
                }
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (finallyScope != null) {
            this.scope.addSubscope(finallyScope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.tryBlock.traverse(visitor, this.scope);
            if (this.catchArguments != null) {
                int max = this.catchBlocks.length;
                for (int i = 0; i < max; ++i) {
                    this.catchArguments[i].traverse(visitor, this.scope);
                    this.catchBlocks[i].traverse(visitor, this.scope);
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

