/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.jres.BuildJREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsComboBlock;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JREContainerWizardPage
extends WizardPage
implements IClasspathContainerPage {
    private IClasspathEntry fSelection;
    private JREsComboBlock fJREBlock;
    private Image fImage;

    public JREContainerWizardPage() {
        super(JREMessages.getString("JREContainerWizardPage.JRE_System_Library_1"));
    }

    public boolean finish() {
        IVMInstall vm;
        Path path = new Path(JavaRuntime.JRE_CONTAINER);
        if (!this.fJREBlock.isDefaultJRE() && (vm = this.fJREBlock.getJRE()) != null && !vm.equals(JavaRuntime.getDefaultVMInstall())) {
            path = path.append(vm.getVMInstallType().getId());
            path = path.append(vm.getName());
        }
        this.fSelection = JavaCore.newContainerEntry((IPath)path);
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fSelection;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fSelection = containerEntry;
        this.initializeFromSelection();
    }

    protected void initializeFromSelection() {
        if (this.getControl() != null) {
            String typeId = null;
            String name = null;
            if (this.fSelection != null) {
                IPath path = this.fSelection.getPath();
                if (path.segmentCount() > 1) {
                    typeId = path.segment(1);
                    name = path.segment(2);
                } else {
                    this.fJREBlock.setUseDefaultJRE();
                    return;
                }
            }
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            for (int i = 0; i < types.length; ++i) {
                IVMInstallType type = types[i];
                if (!type.getId().equals(typeId)) continue;
                IVMInstall[] installs = type.getVMInstalls();
                for (int j = 0; j < installs.length; ++j) {
                    IVMInstall install = installs[j];
                    if (!install.getName().equals(name)) continue;
                    this.fJREBlock.setJRE(install);
                    return;
                }
            }
            this.fJREBlock.setJRE(null);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.fJREBlock = new JREsComboBlock();
        this.fJREBlock.setDefaultJREDescriptor(new BuildJREDescriptor());
        this.fJREBlock.setTitle(JREMessages.getString("JREContainerWizardPage.3"));
        this.fJREBlock.createControl(composite);
        gd = new GridData(768);
        this.fJREBlock.getControl().setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.setTitle(JREMessages.getString("JREContainerWizardPage.JRE_System_Library_1"));
        this.setMessage(JREMessages.getString("JREContainerWizardPage.Select_the_JRE_used_to_build_this_project._4"));
        this.initializeFromSelection();
    }

    public Image getImage() {
        if (this.fImage == null) {
            this.fImage = JavaDebugImages.DESC_WIZBAN_LIBRARY.createImage();
        }
        return this.fImage;
    }

    public void dispose() {
        super.dispose();
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }
}

