/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.help.WorkbenchHelp;

public class SkipAllBreakpointsAction
extends Action
implements IWorkbenchWindowActionDelegate,
IBreakpointManagerListener {
    private IAction fAction;

    public SkipAllBreakpointsAction() {
        super(ActionMessages.getString("SkipAllBreakpointsAction.0"));
        this.setToolTipText(ActionMessages.getString("SkipAllBreakpointsAction.0"));
        this.setDescription(ActionMessages.getString("SkipAllBreakpointsAction.2"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_SKIP_BREAKPOINTS"));
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.SKIP_ALL_BREAKPOINT_ACTION);
        this.updateActionCheckedState();
    }

    public void run() {
        IBreakpointManager manager;
        manager.setEnabled(!(manager = SkipAllBreakpointsAction.getBreakpointManager()).isEnabled());
    }

    public void updateActionCheckedState() {
        if (this.fAction != null) {
            this.fAction.setChecked(!SkipAllBreakpointsAction.getBreakpointManager().isEnabled());
        } else {
            this.setChecked(!SkipAllBreakpointsAction.getBreakpointManager().isEnabled());
        }
    }

    public static IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    public void dispose() {
        SkipAllBreakpointsAction.getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public void init(IWorkbenchWindow window) {
        this.updateActionCheckedState();
        SkipAllBreakpointsAction.getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        if (this.fAction != null) {
            this.fAction.setChecked(!enabled);
        }
    }
}

