/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class CopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private TreeViewer fViewer;
    static /* synthetic */ Class class$org$eclipse$debug$ui$IDebugView;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter = (IDebugView)this.getView().getAdapter(class$org$eclipse$debug$ui$IDebugView == null ? (class$org$eclipse$debug$ui$IDebugView = CopyToClipboardActionDelegate.class$("org.eclipse.debug.ui.IDebugView")) : class$org$eclipse$debug$ui$IDebugView);
            if (adapter != null) {
                if (adapter.getViewer() instanceof ContentViewer) {
                    this.setViewer((TreeViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return IDebugView.COPY_ACTION;
    }

    protected boolean isEnabledFor(Object element) {
        return this.getViewer() != null && element instanceof IDebugElement;
    }

    protected void doAction(TreeItem item, StringBuffer buffer) {
        this.append(item, buffer, 0);
    }

    protected void append(TreeItem item, StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append('\t');
        }
        buffer.append(item.getText());
        buffer.append(System.getProperty("line.separator"));
        if (this.shouldAppendChildren(item)) {
            TreeItem[] children = item.getItems();
            for (int i = 0; i < children.length; ++i) {
                TreeItem child = children[i];
                this.append(child, buffer, indent + 1);
            }
        }
    }

    public void run(IAction action) {
        final Iterator iter = this.pruneSelection();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StringBuffer buffer = new StringBuffer();
                while (iter.hasNext()) {
                    CopyToClipboardActionDelegate.this.doAction((TreeItem)iter.next(), buffer);
                }
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(CopyToClipboardActionDelegate.this.getViewer().getControl().getDisplay());
                try {
                    CopyToClipboardActionDelegate.this.doCopy(clipboard, plainTextTransfer, buffer);
                }
                finally {
                    clipboard.dispose();
                }
            }
        });
    }

    protected void doCopy(Clipboard clipboard, TextTransfer plainTextTransfer, StringBuffer buffer) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getViewer().getControl().getShell(), (String)ActionMessages.getString("CopyToClipboardActionDelegate.Problem_Copying_to_Clipboard_1"), (String)ActionMessages.getString("CopyToClipboardActionDelegate.There_was_a_problem_when_accessing_the_system_clipboard._Retry__2"))) break block3;
                this.doCopy(clipboard, plainTextTransfer, buffer);
            }
        }
    }

    protected Iterator pruneSelection() {
        TreeItem[] selection = this.getViewer().getTree().getSelection();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>(selection.length);
        for (int i = 0; i < selection.length; ++i) {
            TreeItem item = selection[i];
            if (!this.isEnabledFor(item.getData()) || !this.walkHierarchy(item, items)) continue;
            items.add(item);
        }
        return items.iterator();
    }

    protected boolean walkHierarchy(TreeItem item, List elements) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return true;
        }
        if (elements.contains(parent)) {
            return false;
        }
        return this.walkHierarchy(parent, elements);
    }

    protected boolean shouldAppendChildren(TreeItem item) {
        Object data = item.getData();
        return data instanceof IDebugTarget || data instanceof IThread;
    }

    protected TreeViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(TreeViewer viewer) {
        this.fViewer = viewer;
    }

    protected void doAction(Object element) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

