/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class ParameterGuessingProposal
extends JavaCompletionProposal {
    private final char[] fName;
    private final char[][] fParameterNames;
    private final char[][] fParamaterTypePackageNames;
    private final char[][] fParameterTypeNames;
    private final int fCodeAssistOffset;
    private final ICompilationUnit fCompilationUnit;
    private final ITextViewer fViewer;
    private IRegion fSelectedRegion;
    private ICompletionProposal[][] fChoices;
    private IPositionUpdater fUpdater;

    public ParameterGuessingProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, ITextViewer viewer, int relevance, char[] name, char[][] paramaterTypePackageNames, char[][] parameterTypeNames, char[][] parameterNames, int codeAssistOffset, ICompilationUnit compilationUnit) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.fName = name;
        this.fParamaterTypePackageNames = paramaterTypePackageNames;
        this.fParameterTypeNames = parameterTypeNames;
        this.fParameterNames = parameterNames;
        this.fViewer = viewer;
        this.fCodeAssistOffset = codeAssistOffset;
        this.fCompilationUnit = compilationUnit;
    }

    private boolean appendArguments(IDocument document, int offset) {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("content_assist_insert_completion") ^ this.fToggleEating) {
            return true;
        }
        try {
            int index;
            IRegion region = document.getLineInformationOfOffset(offset);
            String line = document.get(region.getOffset(), region.getLength());
            for (index = offset - region.getOffset(); index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index)); ++index) {
            }
            if (index == line.length()) {
                return true;
            }
            return line.charAt(index) != '(';
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            String replacementString;
            Position[] positions;
            int[] positionLengths;
            int[] positionOffsets;
            int parameterCount = this.fParameterNames.length;
            int baseOffset = this.getReplacementOffset();
            if (this.appendArguments(document, offset)) {
                parameterCount = this.fParameterNames.length;
                positionOffsets = new int[parameterCount];
                positionLengths = new int[parameterCount];
                positions = new Position[parameterCount];
                replacementString = this.computeGuessingCompletion(baseOffset, positionOffsets, positionLengths, document, positions);
            } else {
                parameterCount = 0;
                positionOffsets = new int[]{};
                positionLengths = new int[]{};
                positions = new Position[]{};
                replacementString = new String(this.fName);
            }
            this.setReplacementString(replacementString);
            super.apply(document, trigger, offset);
            if (parameterCount > 0) {
                LinkedModeModel model = new LinkedModeModel();
                for (int i = 0; i != parameterCount; ++i) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int positionOffset = baseOffset + positionOffsets[i];
                    if (this.fChoices[i].length < 2) {
                        group.addPosition(new LinkedPosition(document, positionOffset, positionLengths[i], -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), positions[i]);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLengths[i], -1, this.fChoices[i]));
                    }
                    model.addGroup(group);
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.fViewer);
                ui.setExitPosition(this.fViewer, baseOffset + replacementString.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new JavaCompletionProposal.ExitPolicy(')'));
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + replacementString.length(), 0);
            }
        }
        catch (BadLocationException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (JavaModelException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICompletionProposal[][] guessParameters(int offset, IDocument document, Position[] positions) throws JavaModelException {
        this.fChoices = new ICompletionProposal[this.fParameterNames.length][];
        if (this.fCompilationUnit == null) {
            for (int i = 0; i != this.fParameterNames.length; ++i) {
                String name = new String(this.fParameterNames[i]);
                int length = name.length();
                this.fChoices[i] = new JavaCompletionProposal[]{new JavaCompletionProposal(name, offset, length, null, name, 0)};
                offset += length + 2;
            }
            return this.fChoices;
        }
        ICompilationUnit i = this.fCompilationUnit;
        synchronized (i) {
            this.fCompilationUnit.reconcile(0, false, null, null);
        }
        ParameterGuesser guesser = new ParameterGuesser(this.fCodeAssistOffset, this.fCompilationUnit);
        for (int i2 = this.fParameterNames.length - 1; i2 >= 0; --i2) {
            positions[i2] = new Position(0, 0);
            String paramName = new String(this.fParameterNames[i2]);
            ICompletionProposal[] parameters = guesser.parameterProposals(new String(this.fParamaterTypePackageNames[i2]), new String(this.fParameterTypeNames[i2]), paramName, positions[i2], document);
            int paramLength = paramName.length();
            this.fChoices[i2] = parameters == null ? new ICompletionProposal[]{new JavaCompletionProposal(paramName, offset, paramLength, null, paramName, 0)} : parameters;
            offset += paramLength + 2;
        }
        return this.fChoices;
    }

    private String computeGuessingCompletion(int startOffset, int[] offsets, int[] lengths, IDocument document, Position[] positions) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fName);
        buffer.append('(');
        this.fChoices = this.guessParameters(startOffset + buffer.length(), document, positions);
        for (int i = 0; i < this.fChoices.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            offsets[i] = buffer.length();
            ICompletionProposal[] proposals = this.fChoices[i];
            String display = proposals.length > 0 ? proposals[0].getDisplayString() : new String(this.fParameterNames[i]);
            buffer.append(display);
            lengths[i] = buffer.length() - offsets[i];
            if (proposals.length <= 1) continue;
            positions[i].offset = startOffset + offsets[i];
            positions[i].length = lengths[i];
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.getString("ParameterGuessingProposal.error.msg"), (String)e.getMessage());
    }

    public String toString() {
        return this.getDisplayString() + super.toString();
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    ParameterGuessingProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }
}

