/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

class SearchViewSiteAdapter
extends PlatformObject
implements IWorkbenchPartSite {
    private ISelectionProvider fProvider;
    private IWorkbenchSite fSite;
    private ISelectionChangedListener fListener;

    public SearchViewSiteAdapter(IWorkbenchSite site) {
        this.fSite = site;
        this.setSelectionProvider(site.getSelectionProvider());
    }

    public IWorkbenchPage getPage() {
        return this.fSite.getPage();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fProvider;
    }

    public Shell getShell() {
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.fSite.getWorkbenchWindow();
    }

    public void setSelectionProvider(final ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                SearchViewSiteAdapter.this.fListener = new ISelectionChangedListener(this, listener){
                    private final /* synthetic */ ISelectionChangedListener val$listener;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$listener = val$listener;
                    }

                    public void selectionChanged(SelectionChangedEvent event) {
                        this.val$listener.selectionChanged(new SelectionChangedEvent(SearchViewSiteAdapter.access$200(1.access$100(this.this$1)), SearchViewSiteAdapter.access$300(1.access$100(this.this$1), event.getSelection())));
                    }
                };
                provider.addSelectionChangedListener(SearchViewSiteAdapter.this.fListener);
            }

            public ISelection getSelection() {
                return SearchViewSiteAdapter.this.convertSelection(provider.getSelection());
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                provider.removeSelectionChangedListener(SearchViewSiteAdapter.this.fListener);
            }

            public void setSelection(ISelection selection) {
            }

            static /* synthetic */ SearchViewSiteAdapter access$100(1 x0) {
                return x0.SearchViewSiteAdapter.this;
            }
        };
    }

    private ISelection convertSelection(ISelection selection) {
        IMarker marker;
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof ISearchResultViewEntry && (marker = ((ISearchResultViewEntry)element).getSelectedMarker()) != null && marker.exists()) {
            try {
                IJavaElement je = JavaCore.create((String)((String)marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleID")));
                if (je != null) {
                    return new StructuredSelection((Object)je);
                }
            }
            catch (CoreException ex) {
                ExceptionHandler.log(ex, SearchMessages.getString("Search.Error.createJavaElement.message"));
            }
        }
        return StructuredSelection.EMPTY;
    }

    public String getId() {
        return null;
    }

    public IKeyBindingService getKeyBindingService() {
        return null;
    }

    public String getPluginId() {
        return null;
    }

    public String getRegisteredName() {
        return null;
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
    }

    public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
    }

    static /* synthetic */ ISelectionProvider access$200(SearchViewSiteAdapter x0) {
        return x0.fProvider;
    }
}

