/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SchemaSpecSection
extends PDESection {
    public static final String SECTION_TITLE = "SchemaEditor.SpecSection.title";
    public static final String SECTION_DESC = "SchemaEditor.SpecSection.desc";
    public static final String SECTION_PLUGIN = "SchemaEditor.SpecSection.plugin";
    public static final String SECTION_POINT = "SchemaEditor.SpecSection.point";
    public static final String SECTION_NAME = "SchemaEditor.SpecSection.name";
    private FormEntry pluginText;
    private FormEntry pointText;
    private FormEntry nameText;

    public SchemaSpecSection(SchemaFormPage page, Composite parent) {
        super(page, parent, 130);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.pluginText.commit();
        this.pointText.commit();
        this.nameText.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.pluginText.cancelEdit();
        this.pointText.cancelEdit();
        this.nameText.cancelEdit();
        super.cancelEdit();
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        final Schema schema = (Schema)this.getPage().getModel();
        this.pluginText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_PLUGIN), null, false);
        this.pluginText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                schema.setPluginId(text.getValue());
            }
        });
        this.pointText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_POINT), null, false);
        this.pointText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                schema.setPointId(text.getValue());
            }
        });
        this.nameText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_NAME), null, false);
        this.nameText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                schema.setName(text.getValue());
                SchemaSpecSection.this.getPage().getManagedForm().getForm().setText(schema.getName());
            }
        });
        GridData gd = (GridData)this.pointText.getText().getLayoutData();
        gd.widthHint = 150;
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    public void dispose() {
        ISchema schema = (ISchema)this.getPage().getModel();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        ISchema schema = (ISchema)this.getPage().getModel();
        this.refresh();
        if (!(schema instanceof IEditable)) {
            this.pluginText.getText().setEnabled(false);
            this.pointText.getText().setEnabled(false);
            this.nameText.getText().setEnabled(false);
        }
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void setFocus() {
        if (this.pointText != null) {
            this.pointText.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void refresh() {
        ISchema schema = (ISchema)this.getPage().getModel();
        this.setIfDefined(this.pluginText, schema.getPluginId());
        this.setIfDefined(this.pointText, schema.getPointId());
        this.setIfDefined(this.nameText, schema.getName());
        this.getPage().getManagedForm().getForm().setText(schema.getName());
        super.refresh();
    }
}

