/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.schema.DescriptionSection;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.GrammarSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaPropertySheet;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSpecSection;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class SchemaFormPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "form";
    public static final String PAGE_TITLE = "SchemaEditor.FormPage.title";
    private SchemaSpecSection schemaSpecSection;
    private ElementSection elementSection;
    private DescriptionSection descriptionSection;
    private GrammarSection grammarSection;
    private SchemaPropertySheet propertySheetPage;
    private IColorManager colorManager = ColorManager.getDefault();

    public SchemaFormPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEPlugin.getResourceString(PAGE_TITLE));
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 15;
        form.getBody().setLayout((Layout)layout);
        this.schemaSpecSection = new SchemaSpecSection(this, form.getBody());
        GridData gd = new GridData(770);
        this.schemaSpecSection.getSection().setLayoutData((Object)gd);
        this.grammarSection = new GrammarSection(this, form.getBody());
        gd = new GridData(784);
        gd.verticalSpan = 2;
        this.grammarSection.getSection().setLayoutData((Object)gd);
        this.elementSection = new ElementSection(this, form.getBody());
        gd = new GridData(1808);
        this.elementSection.getSection().setLayoutData((Object)gd);
        this.descriptionSection = new DescriptionSection((PDEFormPage)this, form.getBody(), this.colorManager);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.descriptionSection.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.schemaSpecSection);
        managedForm.addPart((IFormPart)this.elementSection);
        managedForm.addPart((IFormPart)this.grammarSection);
        managedForm.addPart((IFormPart)this.descriptionSection);
        WorkbenchHelp.setHelp((Control)form.getBody(), (String)"org.eclipse.pde.doc.user.schema_editor_main");
        this.initialize();
    }

    public void initialize() {
        ISchema schema = (ISchema)this.getModel();
        this.getManagedForm().getForm().setText(schema.getName());
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        ISchema schema = (ISchema)this.getModel();
        this.colorManager.dispose();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new SchemaPropertySheet();
        }
        return this.propertySheetPage;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            ISchema schema = (ISchema)this.getModel();
            this.getManagedForm().getForm().setText(schema.getName());
        }
    }
}

