/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;

public class IndexToolApplication
implements IPlatformRunnable,
IExecutableExtension {
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public Object run(Object args) throws Exception {
        try {
            String directory = System.getProperty("indexOutput");
            if (directory == null || directory.length() == 0) {
                throw new Exception(HelpBaseResources.getString("IndexToolApplication.propertyNotSet", "indexOutput"));
            }
            String localeStr = System.getProperty("indexLocale");
            if (localeStr == null || localeStr.length() < 2) {
                throw new Exception(HelpBaseResources.getString("IndexToolApplication.propertyNotSet", "indexLocale"));
            }
            Locale locale = localeStr.length() >= 5 ? new Locale(localeStr.substring(0, 2), localeStr.substring(3, 5)) : new Locale(localeStr.substring(0, 2), "");
            this.preindex(directory, locale);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            HelpBasePlugin.logError(HelpBaseResources.getString("IndexToolApplication.failed"), e);
        }
        return IPlatformRunnable.EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preindex(String outputDir, Locale locale) throws Exception {
        File indexPath = new File(HelpBasePlugin.getConfigurationDirectory(), "index/" + locale);
        if (indexPath.exists()) {
            IndexToolApplication.delete(indexPath);
        }
        BaseHelpSystem.getSearchManager().ensureIndexUpdated((IProgressMonitor)new NullProgressMonitor(), BaseHelpSystem.getSearchManager().getIndex(locale.toString()));
        File d = new File(outputDir, "nl" + File.separator + locale.getLanguage());
        if (locale.getCountry().length() > 0) {
            d = new File(d, locale.getCountry());
        }
        if (!d.exists()) {
            d.mkdirs();
        }
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(new File(d, "doc_index.zip")));
        try {
            IndexToolApplication.zipDirectory(indexPath, zout, null);
        }
        finally {
            zout.close();
        }
    }

    private static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                IndexToolApplication.delete(files[i]);
            }
        }
        if (!file.delete()) {
            throw new IOException(HelpBaseResources.getString("IndexToolApplication.cannotDelete", file.getAbsolutePath()));
        }
    }

    private static void zipDirectory(File dir, ZipOutputStream zout, String base) throws IOException {
        byte[] buffer = new byte[8192];
        String[] files = dir.list();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            int len;
            String path = base == null ? files[i] : base + "/" + files[i];
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                IndexToolApplication.zipDirectory(f, zout, path);
                continue;
            }
            ZipEntry zentry = new ZipEntry(path);
            zout.putNextEntry(zentry);
            FileInputStream inputStream = new FileInputStream(f);
            while ((len = inputStream.read(buffer)) != -1) {
                zout.write(buffer, 0, len);
            }
            inputStream.close();
            zout.flush();
            zout.closeEntry();
        }
    }
}

