/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.util.BitVector;

class SegmentTermDocs
implements TermDocs {
    protected SegmentReader parent;
    private InputStream freqStream;
    private int freqCount;
    private BitVector deletedDocs;
    int doc = 0;
    int freq;

    SegmentTermDocs(SegmentReader parent) throws IOException {
        this.parent = parent;
        this.freqStream = (InputStream)parent.freqStream.clone();
        this.deletedDocs = parent.deletedDocs;
    }

    public void seek(Term term) throws IOException {
        TermInfo ti = this.parent.tis.get(term);
        this.seek(ti);
    }

    public void seek(TermEnum termEnum) throws IOException {
        TermInfo ti = termEnum instanceof SegmentTermEnum ? ((SegmentTermEnum)termEnum).termInfo() : this.parent.tis.get(termEnum.term());
        this.seek(ti);
    }

    void seek(TermInfo ti) throws IOException {
        if (ti == null) {
            this.freqCount = 0;
        } else {
            this.freqCount = ti.docFreq;
            this.doc = 0;
            this.freqStream.seek(ti.freqPointer);
        }
    }

    public void close() throws IOException {
        this.freqStream.close();
    }

    public final int doc() {
        return this.doc;
    }

    public final int freq() {
        return this.freq;
    }

    protected void skippingDoc() throws IOException {
    }

    public boolean next() throws IOException {
        while (true) {
            if (this.freqCount == 0) {
                return false;
            }
            int docCode = this.freqStream.readVInt();
            this.doc += docCode >>> 1;
            this.freq = (docCode & 1) != 0 ? 1 : this.freqStream.readVInt();
            --this.freqCount;
            if (this.deletedDocs == null || !this.deletedDocs.get(this.doc)) break;
            this.skippingDoc();
        }
        return true;
    }

    public int read(int[] docs, int[] freqs) throws IOException {
        int end = docs.length;
        int i = 0;
        while (i < end && this.freqCount > 0) {
            int docCode = this.freqStream.readVInt();
            this.doc += docCode >>> 1;
            this.freq = (docCode & 1) != 0 ? 1 : this.freqStream.readVInt();
            --this.freqCount;
            if (this.deletedDocs != null && this.deletedDocs.get(this.doc)) continue;
            docs[i] = this.doc;
            freqs[i] = this.freq;
            ++i;
        }
        return i;
    }

    public boolean skipTo(int target) throws IOException {
        do {
            if (this.next()) continue;
            return false;
        } while (target > this.doc);
        return true;
    }
}

