/*	$NetBSD: octeon_dma.c,v 1.2 2016/07/11 16:15:35 matt Exp $	*/

/*-
 * Copyright (c) 2001 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Platform-specific DMA support for the MIPS OCTEON.  Copied from MALTA code.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: octeon_dma.c,v 1.2 2016/07/11 16:15:35 matt Exp $");

#include <sys/param.h>
#include <sys/systm.h>

#include <mips/cpuregs.h>

#define	_MIPS_BUS_DMA_PRIVATE
#include <sys/bus.h>

#include <mips/cavium/octeonvar.h>

void
octeon_dma_init(struct octeon_config *mcp)
{
	bus_dma_tag_t t;

	/* XXX need 32bit tag? */
	t = &mcp->mc_iobus_dmat;
	t->_cookie = mcp;
	t->_wbase = 0;
	t->_bounce_alloc_lo = 0;
	t->_bounce_alloc_hi = 0;
	t->_dmamap_ops = mips_bus_dmamap_ops;
	t->_dmamem_ops = mips_bus_dmamem_ops;
	t->_dmatag_ops = mips_bus_dmatag_ops;

	/* XXX struct copy */
	mcp->mc_bootbus_dmat = mcp->mc_iobus_dmat;
	mcp->mc_core1_dmat = mcp->mc_iobus_dmat;
	mcp->mc_fpa_dmat = mcp->mc_iobus_dmat;

#ifdef __mips_n32
	mcp->mc_fpa_dmat._bounce_alloc_hi = round_page(MIPS_PHYS_MASK);
#endif
}
