/*	$NetBSD: keygen.h,v 1.4 2014/12/10 04:37:51 christos Exp $	*/

/*
 * Copyright (C) 2009  Internet Systems Consortium, Inc. ("ISC")
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/* Id: keygen.h,v 1.3 2009/06/11 23:47:55 tbox Exp  */

#ifndef RNDC_KEYGEN_H
#define RNDC_KEYGEN_H 1

/*! \file */

#include <isc/lang.h>

ISC_LANG_BEGINDECLS

void generate_key(isc_mem_t *mctx, const char *randomfile, dns_secalg_t alg,
		  int keysize, isc_buffer_t *key_txtbuffer);

void write_key_file(const char *keyfile, const char *user,
		    const char *keyname, isc_buffer_t *secret,
		    dns_secalg_t alg);

const char *alg_totext(dns_secalg_t alg);
dns_secalg_t alg_fromtext(const char *name);
int alg_bits(dns_secalg_t alg);

ISC_LANG_ENDDECLS

#endif /* RNDC_KEYGEN_H */
