/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.PlacementGroupDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribePlacementGroups
extends BaseCmd {
    public DescribePlacementGroups(String[] args) {
        super("ec2dpgrp", "ec2-describe-placement-groups");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[GROUP_NAME [GROUP_NAME [...]]]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes the specified placement groups");
        System.out.println("     or all placement groups, if none is specified.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        List<String> groupNames = this.getPlacementGroupNames();
        RequestResultPair rsp = jec2.describePlacementGroups(groupNames, this.getFilters(true));
        for (PlacementGroupDescription descr : (List)rsp.getResponse()) {
            out.outputPlacementGroup(System.out, descr.getGroupName(), descr.getStrategy(), descr.getState());
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DescribePlacementGroups(args).invoke();
    }

    protected List<String> getPlacementGroupNames() {
        String[] groupNames = this.getNonOptions();
        return Arrays.asList(groupNames);
    }
}

