/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.interceptor;

import alt.jiapi.event.EventInstrumentor;
import alt.jiapi.interceptor.FieldHandler;
import alt.jiapi.interceptor.FieldInterceptor2;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.Signature;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.util.HotSpot;
import alt.jiapi.util.HotSpotLocator;
import java.lang.reflect.Modifier;

class FieldInstrumentor
extends EventInstrumentor {
    private FieldHandler handler;
    private JiapiMethod getMethod;
    private JiapiMethod setMethod;

    FieldInstrumentor(FieldInterceptor2 ii, FieldHandler handler) {
        super(ii);
        this.handler = handler;
        JiapiClass jc = this.getEventProducer();
        try {
            this.getMethod = jc.getDeclaredMethod("getField", new String[]{"java.lang.Object", "java.lang.String"});
            this.setMethod = jc.getDeclaredMethod("setField", new String[]{"java.lang.Object", "java.lang.String", "java.lang.Object"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void instrument(JiapiMethod jm) {
        JiapiField interceptor = this.getEventProducerField();
        InstructionList il = jm.getInstructionList();
        InstructionFactory factory = il.getInstructionFactory();
        HotSpotLocator hsl = new HotSpotLocator(il, new byte[]{-78});
        HotSpot[] hotSpots = hsl.getHotSpots();
        for (int i = 0; i < hotSpots.length; ++i) {
            FieldAccess fa = (FieldAccess)hotSpots[i].getHotSpotInstruction();
            if (fa.getName().startsWith("__jiapi") || !this.match(fa.getClassName() + "." + fa.getFieldName()) || !this.isPublicField(fa)) continue;
            InstructionList hsList = hotSpots[i].getInstructionList();
            InstructionList nList = il.createEmptyList();
            nList.add(factory.getField(interceptor));
            if (fa.getOpcode() == -78 || fa.getOpcode() == -77) {
                this.addClassForNameInstructions(fa.getClassName(), nList);
            } else {
                nList.add(il.get(0));
            }
            nList.add(factory.pushConstant(fa.getClassName() + "." + fa.getFieldName()));
            if (fa.getOpcode() == -78 || fa.getOpcode() == -76) {
                nList.add(factory.invoke(this.getMethod));
            } else {
                nList.add(il.get(1));
                nList.add(factory.invoke(this.setMethod));
            }
            this.handleReturnValue(nList, fa.getTypeName());
            hsList.replace(nList);
        }
    }

    private void addClassForNameInstructions(String name, InstructionList il) {
        InstructionFactory f = il.getInstructionFactory();
        InstructionList nl = il.createEmptyList();
        try {
            nl.add(f.pushConstant(name));
            nl.add(f.invoke(8, "java.lang.Class", "forName", new Signature("java.lang.Class", new String[]{"java.lang.String"})));
        }
        catch (Exception e) {
            e.printStackTrace();
            il.add(f.pushNull());
        }
        il.add(nl);
    }

    private boolean isPublicField(FieldAccess fa) {
        try {
            JiapiClass jc = new Loader().loadClass(fa.getClassName());
            JiapiField jf = jc.getField(fa.getName());
            return Modifier.isPublic(jf.getModifiers());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void handleReturnValue(InstructionList il, String rType) {
        InstructionFactory factory = il.getInstructionFactory();
        if ("int".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Integer");
                JiapiMethod jm = jc.getDeclaredMethod("intValue", new String[0]);
                il.add(factory.cast("java.lang.Integer"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("long".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Long");
                JiapiMethod jm = jc.getDeclaredMethod("longValue", new String[0]);
                il.add(factory.cast("java.lang.Long"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("char".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Character");
                JiapiMethod jm = jc.getDeclaredMethod("charValue", new String[0]);
                il.add(factory.cast("java.lang.Character"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("boolean".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Boolean");
                JiapiMethod jm = jc.getDeclaredMethod("booleanValue", new String[0]);
                il.add(factory.cast("java.lang.Boolean"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("byte".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Byte");
                JiapiMethod jm = jc.getDeclaredMethod("byteValue", new String[0]);
                il.add(factory.cast("java.lang.Byte"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("float".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Float");
                JiapiMethod jm = jc.getDeclaredMethod("floatValue", new String[0]);
                il.add(factory.cast("java.lang.Float"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("double".equals(rType)) {
            try {
                JiapiClass jc = new Loader().loadClass("java.lang.Double");
                JiapiMethod jm = jc.getDeclaredMethod("doubleValue", new String[0]);
                il.add(factory.cast("java.lang.Double"));
                il.add(factory.invoke(jm));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("void".equals(rType)) {
            il.add(new Instruction(new byte[]{87}));
        } else {
            il.add(factory.cast(rType));
        }
    }
}

