/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;

class MethodFilter
implements Filter {
    String name;
    int nlen;
    int modifiers;
    int modmask;
    ClassType caller;

    public MethodFilter(String name, int modifiers, int modmask, ClassType caller) {
        this.name = name;
        this.nlen = name.length();
        this.modifiers = modifiers;
        this.modmask = modmask;
        this.caller = caller;
    }

    public boolean select(Object value) {
        char c;
        Method method = (Method)value;
        String mname = method.getName();
        int mmods = method.getModifiers();
        if ((mmods & this.modmask) != this.modifiers || !mname.startsWith(this.name)) {
            return false;
        }
        int mlen = mname.length();
        if (!(mlen == this.nlen || mlen == this.nlen + 2 && mname.charAt(this.nlen) == '$' && ((c = mname.charAt(this.nlen + 1)) == 'V' || c == 'X') || mlen == this.nlen + 4 && mname.endsWith("$V$X"))) {
            return false;
        }
        return this.caller == null || this.caller.isAccessible(method.getDeclaringClass(), mmods);
    }
}

