/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;

public class FlatSlidingButtonUI
extends SlidingButtonUI {
    private boolean defaults_initialized = false;
    private Color hoverBackground;
    private Color selectedBackground;
    private Color attentionBackground;
    private Color attentionForeground;
    private static final FlatSlidingButtonUI INSTANCE = new FlatSlidingButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.hoverBackground = UIManager.getColor("SlidingButton.hoverBackground");
            this.selectedBackground = UIManager.getColor("SlidingButton.selectedBackground");
            this.attentionBackground = UIManager.getColor("SlidingButton.attentionBackground");
            this.attentionForeground = UIManager.getColor("SlidingButton.attentionForeground");
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(abstractButton, "opaque", false);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (((SlidingButton)jComponent).isBlinkState()) {
            graphics.setColor(this.attentionBackground);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        super.paint(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (((SlidingButton)abstractButton).isBlinkState()) {
            return;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        graphics.setColor(buttonModel.isPressed() || buttonModel.isArmed() || buttonModel.isSelected() ? this.selectedBackground : this.hoverBackground);
        graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        if (((SlidingButton)abstractButton).isBlinkState()) {
            Color color = abstractButton.getForeground();
            abstractButton.setForeground(this.attentionForeground);
            super.paintText(graphics, abstractButton, rectangle, string);
            abstractButton.setForeground(color);
        } else {
            super.paintText(graphics, abstractButton, rectangle, string);
        }
    }
}

