/*
 * Decompiled with CFR 0.152.
 */
package es.blackleg.jlibnotify.core;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.Native;
import com.sun.jna.TypeConverter;
import com.sun.jna.platform.EnumConverter;
import es.blackleg.jlibnotify.JLibnotify;
import es.blackleg.jlibnotify.JLibnotifyLoader;
import es.blackleg.jlibnotify.core.DefaultJLibnotify;
import es.blackleg.jlibnotify.core.DefaultServerCapabilitiesReader;
import es.blackleg.jlibnotify.core.ServerCapabilitiesReader;
import es.blackleg.jlibnotify.exception.JLibnotifyLoadException;
import es.blackleg.jlibnotify.jna.GBoolean;
import es.blackleg.jlibnotify.jna.NativeLibnotify;
import java.util.HashMap;

public class DefaultJLibnotifyLoader
implements JLibnotifyLoader {
    private final String libraryName;
    private final ServerCapabilitiesReader serverCapabilitiesReader;

    public DefaultJLibnotifyLoader() {
        this.libraryName = "libnotify.so.4";
        this.serverCapabilitiesReader = new DefaultServerCapabilitiesReader();
    }

    public DefaultJLibnotifyLoader(String libraryName) {
        this.libraryName = libraryName;
        this.serverCapabilitiesReader = new DefaultServerCapabilitiesReader();
    }

    public DefaultJLibnotifyLoader(String libraryName, ServerCapabilitiesReader serverCapabilitiesReader) {
        this.libraryName = libraryName;
        this.serverCapabilitiesReader = serverCapabilitiesReader;
    }

    @Override
    public JLibnotify load() throws JLibnotifyLoadException {
        try {
            EnumConverter enumConverter = new EnumConverter(GBoolean.class);
            DefaultTypeMapper defaultTypeMapper = new DefaultTypeMapper();
            defaultTypeMapper.addTypeConverter(GBoolean.class, (TypeConverter)enumConverter);
            HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
            options.put("type-mapper", defaultTypeMapper);
            NativeLibnotify nativeLibNotify = (NativeLibnotify)Native.load((String)this.libraryName, NativeLibnotify.class, options);
            return new DefaultJLibnotify(nativeLibNotify, this.serverCapabilitiesReader);
        }
        catch (Throwable throwable) {
            throw new JLibnotifyLoadException(String.format("Unable to load %s library", this.libraryName), throwable);
        }
    }

    public static JLibnotifyLoader init() {
        return new DefaultJLibnotifyLoader();
    }
}

