/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.ast.InvisibleNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;

public abstract class Node {
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    private int line;
    protected boolean containsVariableAssignment;
    protected boolean newline;

    public Node(int line, boolean containsAssignment) {
        this.line = line;
        this.containsVariableAssignment = containsAssignment;
    }

    public void setNewline() {
        this.newline = true;
    }

    public void unsetNewline() {
        this.newline = false;
    }

    public boolean isNewline() {
        return this.newline;
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return null;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public abstract <T> T accept(NodeVisitor<T> var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node node) {
        return Collections.singletonList(node);
    }

    protected static List<Node> createList(Node node1, Node node2) {
        ArrayList<Node> list2 = new ArrayList<Node>(2);
        list2.add(node1);
        list2.add(node2);
        return list2;
    }

    protected static List<Node> createList(Node node1, Node node2, Node node3) {
        ArrayList<Node> list2 = new ArrayList<Node>(3);
        list2.add(node1);
        list2.add(node2);
        list2.add(node3);
        return list2;
    }

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list2 = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            if (node == null) continue;
            list2.add(node);
        }
        return list2;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toStringExtraInfo() {
        return null;
    }

    public String toString(boolean indent, int indentation) {
        String moreState;
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        if (indent) {
            Node.indent(indentation, builder);
        }
        builder.append('(').append(this.getNodeName());
        if (this.isNewline()) {
            builder.append('*');
        }
        if ((moreState = this.toStringInternal()) != null) {
            builder.append("[").append(moreState).append("]");
        }
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        builder.append(" line: ").append(this.getLine());
        String extraInfo = this.toStringExtraInfo();
        if (extraInfo != null) {
            builder.append(", ").append(extraInfo);
        }
        if (!this.childNodes().isEmpty() && indent) {
            builder.append("\n");
        }
        for (Node child : this.childNodes()) {
            if (!indent) {
                builder.append(", ");
            }
            if (child == null) {
                if (indent) {
                    Node.indent(indentation + 1, builder);
                }
                builder.append("null");
            } else if (indent && child instanceof NilImplicitNode) {
                Node.indent(indentation + 1, builder);
                builder.append(child.getClass().getSimpleName());
            } else {
                builder.append(child.toString(indent, indentation + 1));
            }
            if (!indent) continue;
            builder.append("\n");
        }
        if (!this.childNodes().isEmpty() && indent) {
            Node.indent(indentation, builder);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String toStringInternal() {
        return null;
    }

    private static void indent(int indentation, StringBuilder builder) {
        builder.append("  ".repeat(Math.max(0, indentation)));
    }

    protected String getNodeName() {
        String name2 = this.getClass().getName();
        return name2.substring(name2.lastIndexOf(46) + 1);
    }

    public abstract NodeType getNodeType();

    public boolean isNil() {
        return false;
    }

    public boolean needsDefinitionCheck() {
        return true;
    }

    public boolean containsVariableAssignment() {
        return this.containsVariableAssignment;
    }

    public boolean executesOnce() {
        return false;
    }
}

