---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "ワークフローに固有の特定の情報を追跡するために、作業アイテムのカスタムフィールドを作成して使用します。計画およびレポート機能を強化するために、フィールドの種類を設定します。"
title: カスタムフィールド
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.11で`custom_fields_feature`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/479571)されました。GitLab.com、GitLab Self-Managed、GitLab Dedicatedで有効。
- GitLab 18.0[で一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/479571)になりました。機能フラグ`custom_fields_feature`は削除されました。

{{< /history >}}

カスタムフィールドを使用すると、イシューやエピックなどの作業アイテムに、特定の計画ニーズに合わせた特殊な情報を追加できます。グループのカスタムフィールドを設定して、ビジネス価値、リスク評価、優先順位付け、チーム属性などのデータポイントを追跡します。これらのフィールドは、グループ、サブグループ、およびプロジェクト全体のすべての作業アイテムに表示されます。

カスタムフィールドは、チームがワークフロー全体の情報を記録およびレポートする方法を標準化するのに役立ちます。この標準化により、プロジェクト全体で一貫性が生まれ、より強力なフィルタリングとレポート機能がサポートされます。さまざまなデータの要件と計画のシナリオに対応するために、さまざまなフィールドタイプから選択します:

- 単一選択
- 複数選択
- 数値
- テキスト

## グループのカスタムフィールドを設定する {#configure-custom-fields-for-a-group}

トップレベルグループのカスタムフィールドを設定して、そのグループ、サブグループ、およびプロジェクトの作業アイテムで使用できるようにします。

### カスタムフィールドを作成する {#create-a-custom-field}

チームが追跡する必要のある特定の情報を取得するためのカスタムフィールドを作成します。各フィールドを1つ以上の作業アイテムタイプに設定して、組織の要件に合わせてワークフローを調整できます。

これらの制限に注意してください:

- トップレベルグループは、最大50のアクティブなカスタムフィールドを持つことができます。
- 1つの作業アイテムタイプに割り当てできるカスタムフィールドは最大10個です。

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。

カスタムフィールドを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. **フィールドを作成する**を選択します。
1. フィールドに入力します:
   - **種類**で、フィールドのタイプを選択します:
     - 単一選択
     - 複数選択
     - 数値
     - テキストフィールド

     フィールドの種類は、フィールドを作成した後は変更できません。
   - **以下の項目で使用**で、このフィールドを使用する作業アイテムタイプを選択します。
   - **オプション**で、選択可能なオプションを入力します。単一選択または複数選択フィールドには、最大50個の選択オプションを設定できます。
     - 各オプションの左側にあるグリップアイコン（{{< icon name="grip" >}}）をドラッグして、オプションを並べ替えます。
     - 複数のオプションを一度に追加するには、入力を選択し、項目のリストを1行に1つずつ貼り付けます。
1. **保存**を選択します。

### カスタムフィールドを編集する {#edit-a-custom-field}

組織の変化するニーズを反映するように、既存のカスタムフィールドを編集します。既存のデータを失うことなく、フィールドの名前、適用する作業アイテムの種類、および利用可能なオプションを変更できます。

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。

カスタムフィールドを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. 編集するフィールドの横にある**`<field name>`を編集**（{{< icon name="pencil" >}}）を選択します。
1. 任意のフィールドに変更を加えます。
1. **更新**を選択します。

### カスタムフィールドをアーカイブする {#archive-a-custom-field}

不要になったカスタムフィールドをアーカイブして、履歴データを保持します。アーカイブすると、フィールドを持つすべての作業アイテムからフィールドが削除されます。

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。

カスタムフィールドをアーカイブするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. アーカイブするフィールドの横にある**`<field name>`をアーカイブ**（{{< icon name="archive" >}}）を選択します。

### カスタムフィールドのアーカイブ解除 {#unarchive-a-custom-field}

再度使用する必要がある場合は、以前にアーカイブされたカスタムフィールドを復元します。このフィールドに値が設定されていた作業アイテムは、フィールドがアーカイブされる前の同じ値を保持します。

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。

カスタムフィールドをアーカイブ解除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. アーカイブされたフィールドを一覧表示するには、**アーカイブ済み**タブを選択します。
1. アーカイブを解除するフィールドの横にある**`<field name>`のアーカイブ解除**（{{< icon name="redo" >}}）を選択します。

## 作業アイテムのカスタムフィールド値を設定する {#set-custom-field-values-for-a-work-item}

グループに設定されたカスタムフィールドを使用して、関連情報を作業アイテムに追加します。

前提要件: 

- 作業アイテムのプロジェクトまたはグループに対する作業アイテムのプランナー以上のロールを持っている必要があります。
- ゲストロールをお持ちの場合は、作業アイテムの作成時にのみカスタムフィールドを設定できます。

1. 作業アイテムに移動します。
1. 右側のサイドバーで、編集するカスタムフィールドのセクションを見つけ、**編集**を選択します。
1. 目的の値を入力または選択します。
   - テキストフィールドの値は、最大1024文字まで可能です。
1. フィールドの外側の領域を選択します。

## フィールドタイプの選択ガイドライン {#field-type-selection-guide}

カスタムフィールドを作成するときは、追跡するデータの種類に一致するフィールドタイプを選択します。適切なフィールドタイプを使用すると、データの品質が向上し、レポートの効果が高まります。

### 単一選択フィールド {#single-select-fields}

単一選択フィールドは、次の場合に使用します:

- ユーザーは、定義済みのリストから1つのオプションを正確に選択する必要があります。
- オプションは相互に排他的です。
- 一貫性を強化し、自由形式の入力を防ぎたい。

単一選択フィールドは、以下に適しています:

- 優先度インジケーター（`High`、`Medium`、`Low`など）
- カテゴリの割り当て
- チーム割り当て
- 承認状態
- 優先度レベル

### 複数選択フィールド {#multi-select-fields}

複数選択フィールドは、次の場合に使用します:

- 複数の値が同時に適用される可能性がある。
- オーバーラップする属性を追跡する必要がある。
- アイテムが複数のカテゴリに属している可能性がある。

複数選択フィールドは、以下に適しています:

- タグ付けまたはラベル
- 必要なスキル
- 影響を受けるコンポーネント
- ステークホルダーグループ
- フィーチャー機能

### 数値フィールド {#number-fields}

数値フィールドは、次の場合に使用します:

- 定量的データを収集する必要がある。
- 計算または集計を実行する。
- 情報を数値で並べ替える必要がある。

数値フィールドは、以下に適しています:

- コスト見積もり
- 時間見積もり
- ビジネス価値スコア
- ランキングまたは優先順位スコア
- 完了率

### テキストフィールド {#text-fields}

テキストフィールドは、次の場合に使用します:

- 定義済みのカテゴリに適合しない一意の情報を取得する必要がある。
- データは非常に多様である。
- コンテキストまたは詳細を提供する必要がある。

テキストフィールドは、以下に適しています:

- 追加のコンテキスト
- 外部リンクID
- 連絡先情報
- 簡単なメモまたはコメント
- URLまたはリンク

## カスタムフィールドの命名規則 {#naming-conventions-for-custom-fields}

カスタムフィールドの一貫した命名規則により、理解と使用が容易になります。フィールド名を適切に付けると、導入とデータの品質が向上します。

### 一般ガイドライン {#general-guidelines}

- 名前は簡潔でありながら説明的にします。
- 組織が理解できる明確で具体的な言語を使用します。
- 大文字と小文字を区別して一貫性を保ちます（タイトルケースを推奨）。
- 広く理解されている場合を除き、略語は避けてください。
- 該当する場合は、測定単位を含めます。

### 単一選択および複数選択フィールドの命名 {#naming-single-select-and-multi-select-fields}

カテゴリ名から始めて、次に記述子を付けます。例: 

- `Risk Level`の代わりに`Risk`
- `Customer Segment`の代わりに`Segment`
- `Development Phase`の代わりに`Phase`
- `Approval Status`の代わりに`Status`

### 数値フィールドの命名 {#naming-number-fields}

フィールド名に測定単位を含めます。例: 

- `Effort Points`の代わりに`Points`
- `Budget Estimate ($)`の代わりに`Budget`
- `Implementation Time (days)`の代わりに`Time`
- `Business Value Score`の代わりに`Value`

### テキストフィールドの命名 {#naming-text-fields}

どのような情報を入力する必要があるかを明確に示します。例: 

- `External Reference ID`の代わりに`Reference`
- `Implementation Notes`の代わりに`Notes`
- `Requirements Source`の代わりに`Source`

### チーム固有のプレフィックス {#team-specific-prefixes}

複数のチームが同じGitLabインスタンスを使用している場合は、混乱を避けるためにチームのプレフィックスを追加することを検討してください:

- `DEV: Sprint Priority`
- `QA: Test Environment`
- `UX: Design Status`
- `PM: Market Segment`

このアプローチは、チームが自分の作業に関連するフィールドを迅速に特定するのに役立ちます。
