---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "作成者、割り当て担当者、コメントを追加したり、リアクションを追加したり、言及されたユーザーを含む、GitLabの作業アイテムおよびマージリクエストを操作したユーザー。"
title: 参加者
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

参加者は、作業アイテムとマージリクエストを操作したユーザーです。これには、作成者、割り当て担当者、レビュアー（マージリクエストの場合）、コメント、絵文字リアクションを追加したユーザー、またはコメントや説明で言及されたユーザーが含まれます。

参加者は、イシュー、タスク、エピックなどの作業アイテム、およびマージリクエストで利用できます。

## 参加者を表示 {#view-participants}

### 作業アイテムの場合 {#for-work-items}

作業アイテムの参加者を表示するには:

1. トップバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. 作業アイテムに移動します:
   - イシューとタスクの場合: **Plan** > **イシュー**を選択し、作業アイテムを選択します。
   - エピックの場合: **Plan** > **エピック**を選択し、エピックを選択します。
1. 右側のサイドバーの**参加者**セクションで、作業アイテムに参加したすべてのユーザーを表示します。

### マージリクエストの場合 {#for-merge-requests}

マージリクエストの参加者を表示するには:

1. トップバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. 右側のサイドバーの**参加者**セクションで、マージリクエストに参加したすべてのユーザーを表示します。

## 参加者の表示レベルと権限 {#participant-visibility-and-permissions}

参加者リストには、作業アイテムまたはマージリクエストにアクセスするために必要な権限を持つユーザーのみが表示されます:

- **Base requirement**\- 参加者として表示するには、作業アイテムまたはマージリクエストに対する読み取り権限が必要です。
- **Internal notes**\- 内部ノートで言及されているユーザーは、内部ノートを読み取り権限を持っている場合にのみ、参加者として表示されます。
- **Mentions add participants**- `@username`または`@team-name`のようなグループメンションで言及されたユーザーは、作業アイテムまたはマージリクエストアクセス権を持っている場合、参加者として追加されます。

> [!warning]グループメンション（`@team-name`など）は、すべての直接グループメンバーを参加者として追加します。一般的な単語で`@`を使用する場合は、既存のグループを誤ってメンションする可能性があるため、注意してください。

## 参加者とメール通知 {#participants-and-email-notifications}

作業アイテムまたはマージリクエストの参加者であることは、メールの通知設定に影響します。この関係を理解することで、通知の好みを効果的に管理できます。

参加者ステータスが通知にどのように関連するか:

- 自動参加: コメント、編集、または作業アイテムまたはマージリクエストで言及されると、自動的に参加者になります。これにより、通知レベル設定に基づいてメール通知がトリガーされる場合があります。
- 通知レベル: あなたの[通知レベル](profile/notifications.md#notification-levels)は、どの活動がメールの通知を生成するかを決定します。
- サブスクライブしている参加者: まだ参加していなくても、作業アイテムまたはマージリクエストの[通知をサブスクライブ](profile/notifications.md#subscribe-to-notifications-for-a-specific-issue-merge-request-or-epic)することができます。これにより、参加者リストにあなたが追加され、デフォルトの通知レベルに基づいて通知がオンになります。
- メンション通知: コメントまたは説明で`@username`で誰かがあなたに言及すると、通知レベル設定に関係なく、通知を受け取り、参加者になります。
- 機密コンテンツ: 機密性の高い作業アイテムの場合、適切な権限を持つユーザーのみが参加者として表示され、通知を受け取ります。詳細については、[参加者の可視性と権限](#participant-visibility-and-permissions)を参照してください。

通知の優先順位の管理に関する詳細については、[通知メール](profile/notifications.md)を参照してください
