---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: リンクされたエピック
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

リンクされたエピックは、2つのエピック間の双方向の関係であり、エピックの説明の下のブロックに表示されます。異なるグループのエピックをリンクできます。

この関係は、ユーザーが両方のエピックを表示できる場合にのみUIに表示されます。オープンなブロッカーを持つエピックを閉じようとすると、警告が表示されます。

当社のAPIを通じてリンクされたエピックを管理するには、[Linked epics API](../../../api/linked_epics.md)を参照してください。

## リンクされたエピックの使用方法 {#ways-to-use-linked-epics}

リンクされたエピックを使用すると、計画と調整に関するいくつかの課題を解決できます。次の例は、リンクされたエピックがチームの連携をより効果的にする方法を示しています。

### 部門横断的な取り組み {#cross-functional-initiatives}

リンクされたエピックを使用して、複数のチーム間の作業を調整し、相互依存的な成果物を追跡します。チームが大規模なイニシアチブで協力する場合、各チームは、関連作業の表示レベルを維持しながら、独自のエピックを管理できます。

たとえば、新機能をリリースする場合、開発チームとマーケティングチームは並行して作業することがよくあります。開発チームはエピックで技術的な実装を追跡し、マーケティングチームは別のエピックでプロモーション活動を計画します。

これらのエピックをリンクすることにより、次のことが可能になります:

- チームは、技術的な作業とプロモーション作業の間の依存関係を追跡できます。
- 各チームは、より広範なイニシアチブとの整合性を維持しながら、自律性を維持します。
- 関係者は、リリースの全スコープに対する表示レベルを得ます。
- チームは、組織の境界を越えてブロッカーを特定し、解決できます。

この調整は、サイロを解消し、イニシアチブのすべての側面が同期を維持するようにします。

グループ間でエピックをリンクする場合:

- 各チームは、自分のグループで作業を保持します。
- チームは、グループを切り替えずに、関連作業を表示できます。
- ステータスの更新は、リンクされたエピック間で自動的に流れます。

### 依存関係管理 {#dependency-management}

リンクされたエピックを使用して、作業の依存関係を管理および追跡します。インフラストラクチャの変更が完了するまで開発を開始できない場合、リンクされたエピックは、チームがこれらの依存関係を管理するのに役立ちます。

たとえば、新機能をビルドする場合、チームは開発を開始する前にインフラストラクチャの更新が必要になることがよくあります。インフラストラクチャチームは、データベース移行作業を1つのエピックで追跡し、開発チームは別のエピックで機能の実装を計画します。

これらのエピックをリンクすることにより、次のことが可能になります:

- チームは、インフラストラクチャの作業が開発の準備ができている時期を追跡できます。
- 開発チームは、スプリントのキャパシティをより適切に計画できます。
- プロダクトマネージャーは、潜在的なワークフローの遅延を特定できます。
- チームは、絶え間ない会議なしに、進捗状況を常に把握できます。

この表示レベルにより、チームは適切な順序で作業を完了し、ブロックされたタスクを回避できます。

依存関係を示すためにエピックをリンクする場合:

- インフラストラクチャと開発の作業は接続されたままになります。
- チームは、作業を開始できる時期を知っています。
- ステータスの更新は、エピック間で自動的に流れます。

### より高度な計画 {#higher-level-planning}

リンクされたエピックを使用して、短期的な実行と長期的な計画を結び付けます。一連のリリースを管理する場合、高レベルの目標を整理し、個々の機能の成果物を追跡できます。

たとえば、数四半期にわたって複数のリリースを計画する場合、各リリースに対して個別のエピックを作成できます。次に、これらのリリースのエピックを、プロジェクト全体を追跡する中央のロードマップのエピックにリンクします。

これらのエピックをリンクすることにより、次のことが可能になります:

- チームは、自分たちの仕事がより大きな戦略にどのように適合するかを理解できます。
- プロダクトマネージャーは、複数のリリースにわたって進捗状況を追跡できます。
- チームは、将来の計画を確認しながら、現在の作業に集中できます。
- 関係者は、詳細な進捗状況と高レベルの進捗状況の両方を監視できます。

この構造は、チームがより広範な目標を維持しながら、現在の作業を進めるのに役立ちます。

計画のためにエピックをリンクする場合:

- 各リリースの進捗状況は、ロードマップに表示されます。
- チームは、今後の作業を早期に確認できます。
- ステータスの更新は、より高いレベルのビューにロールアップされます。

## リンクされたアイテムを追加する {#add-a-linked-item}

{{< history >}}

- イシュー、タスク、目標、および主な成果をリンクする機能は、GitLab 18.1で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/468310)。

{{< /history >}}

エピックと別のアイテムをリンクします:

- エピック
- イシュー
- タスク
- 目標
- 主な成果

前提要件: 

- 両方のグループまたはグループとプロジェクトに対して、少なくともゲストロールが必要です。
- GitLab SaaSの場合: 編集するエピックは、GitLab Ultimateのグループに存在する必要があります。リンクするエピックは、下位層のグループに存在できます。

あるエピックを別のアイテムにリンクするには:

1. エピックの**リンクされたアイテム**セクションで、**追加**を選択します。
1. 2つのアイテム間の関係を次のいずれかから選択します:

   - **次のアイテムに関連している**
   - **次のアイテムをブロックしている**
   - **次のアイテムにブロックされている**

1. リンクされたアイテムを入力するには、次のいずれかを行います:

   - `#`に続けて、アイテムの番号を入力します。たとえば`#123`などです。
   - `#`に続けて、アイテムのタイトルから単語を入力します。たとえば`#Deliver`などです。
   - アイテムの完全なURLを貼り付けます。

   同じグループのアイテムは、参照番号だけで指定できます。別のグループのアイテムには、グループ名のような追加情報が必要です。例: 

   - 同じグループ: `#44`
   - 別のグループ: `group#44`

   有効な参照は、確認できる一時的なリストに追加されます。

1. **追加**を選択します。

リンクされたアイテムは、関係によってグループ化されたエピックに表示されます。この関係は、ユーザーが両方のアイテムを表示できる場合にのみUIに表示されます。

または、[クイックアクション](../../project/quick_actions.md)を使用してリンクされたアイテムを追加することもできます:

- `/relate`
- `/blocks`
- `/blocked_by`

## リンクされたアイテムを削除する {#remove-a-linked-item}

前提要件: 

- エピックのグループに対して、少なくともゲストのロールが必要です。

リンクされたアイテムを削除するには:

1. 説明の下部にある、作業項目の**リンクされたアイテム**セクションを見つけます。
1. リンクされたアイテムごとに、**削除** ({{< icon name="close" >}}) を選択します。

関係は両方のエピックから削除されます。

## ブロックしているエピック {#blocking-epics}

[リンクされたアイテムを追加](#add-a-linked-item)すると、別のエピックを**次のアイテムをブロックしている**か、**次のアイテムにブロックされている**ことを示すことができます。

**Close epic**（エピックを閉じる）ボタンを使用してブロックされたエピックを閉じようとすると、確認メッセージが表示されます。
