---
stage: AI-powered
group: Editor Extensions
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: ローカルエージェント実行でGitLabエディタ拡張機能を使用する場合のセキュリティに関する考慮事項。
title: エディタ拡張機能のセキュリティに関する考慮事項
---

（ソフトウェア開発フローなど）エージェントをローカルで実行するGitLabエディタ拡張機能を使用する場合は、セキュリティ上の影響を理解し、開発環境を保護するためのベストプラクティスに従ってください。

## ローカルエージェント実行のリスク {#local-agent-execution-risks}

GitLabエディタ拡張機能は、デベロッパーのワークステーションでローカルにエージェントを実行できます。これらのエージェントはコンテナ分離なしで実行されるため、システムリソースに直接アクセスできます。

### ファイルシステムへのアクセス {#file-system-access}

エージェントは、操作の種類に応じて異なるファイルアクセスレベルを持ちます。

#### ファイル操作 {#file-operations}

エージェントは、次のファイルに対してファイル操作（読み取り、書き込み、編集、検索、リスト）を実行できます:

- GitLabプロジェクトのGitリポジトリにあるファイル。
- `.gitignore`ルールによって除外されていないファイル。
- Gitリポジトリ内のファイルを指す、有効または解決可能なシンボリックリンク。

#### ファイルに対するShell操作 {#shell-operations-on-files} 

エージェントによって実行されるShellコマンドは、Gitリポジトリの外部にあるファイルや、`.gitignore`パターンに一致するファイルなど、すべてのファイルにアクセスできます。

### 環境変数へのアクセス {#environment-variable-access}

エージェントは、次のものを除き、Shellセッションのすべての環境変数にアクセスできます:

- `CI_JOB_TOKEN`
- `GITLAB_OAUTH_TOKEN`
- `DUO_WORKFLOW_SERVICE_TOKEN`

### システムリソース {#system-resources}

エージェントは、次のシステムリソースにアクセスできます:

- ネットワークリクエスト: エージェントは、ワークステーションからネットワークリクエストを行うことができます。
- プロセスの実行: エージェントは、Shell環境でコマンドを実行できます。

### セキュリティ上の脅威 {#security-threats}

分離が行われていないため、次の脅威が考えられます:

- プロンプトインジェクション: 悪意のあるプロンプトは、エージェントの動作を操作し、意図しないアクションを実行します。
- エージェントの侵害: 侵害されたエージェントは、ワークステーションリソースへのアクセスを提供します。
- データの流出: パスワード、コード、個人ファイルなどの機密データを含む、ワークステーション上のすべてのデータが盗まれる可能性があります。
- ラテラルムーブメント: 漏洩した認証情報により、他のシステムやサービスへのアクセスが可能になります。

## 推奨されるセキュリティ対策 {#recommended-security-practices}

開発環境を保護するには、次のセキュリティのベストプラクティスに従ってください。

### 承認前にツール呼び出しをレビュー {#review-tool-calls-before-approval}

エージェントがアクションの実行をリクエストする場合は、承認する前に、各ツール呼び出しを注意深くレビューしてください。

以下を確認します。

- コマンドとファイル操作は、意図したタスクと一致している。
- ファイルパスは、シンボリックリンクターゲットファイルを含め、予期されるディレクトリ内にあります。 
- コマンド引数に、予期しないフラグまたはパラメータが含まれていません。
- 機密性の高いファイルアクセスとネットワークリクエストは、タスクに必要です。

### MCPサーバーのソースとアクセス許可を確認する {#verify-mcp-server-sources-and-permissions}

GitLab DuoでModel Context Protocol（MCP）サーバーを安全に使用するには、次のようにします:

- 信頼できるソースからのみMCPサーバーを有効にします。
- 各MCPサーバーがリクエストするアクセス許可と機能を確認します。
- 有効にする前に、MCPサーバーがアクセスできるデータを確認します。
- 環境内で有効になっているMCPサーバーを定期的に監査します。

### 分離に開発コンテナを使用する {#use-development-containers-for-isolation}

ローカル実行のリスクを軽減するために、開発コンテナを使用します。

開発コンテナは以下を提供します:

- プロセスの分離: エージェントをホストマシン上で直接ではなく、分離されたコンテナ環境で実行します。
- 制限付きファイルシステムへのアクセス: 必要なファイルのみへのアクセスを制限するようにコンテナを構成します。
- 認証情報の分離: 認証情報を個別に管理し、必要に応じてコンテナに挿入します。
- ネットワーク分離: 外部アクセスを制限するために、コンテナネットワーキングを制限します。

VS Code用GitLab Workflow拡張機能は、VS Code Devコンテナと互換性があります。詳細については、[Visual Studio Code Devコンテナで拡張機能を使用する](visual_studio_code/setup.md#use-the-extension-in-a-visual-studio-code-dev-container)を参照してください。
