# frozen_string_literal: true

class QueueBackfillOccurrenceIdToVulnerabilitySeverityOverrides < Gitlab::Database::Migration[2.3]
  milestone '18.7'
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillOccurrenceIdToVulnerabilitySeverityOverrides"

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_severity_overrides,
      :id
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_severity_overrides, :id, [])
  end
end
