﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/devicefarm/model/Run.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DeviceFarm {
namespace Model {
/**
 * <p>Represents the result of a list runs request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRunsResult">AWS
 * API Reference</a></p>
 */
class ListRunsResult {
 public:
  AWS_DEVICEFARM_API ListRunsResult() = default;
  AWS_DEVICEFARM_API ListRunsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DEVICEFARM_API ListRunsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the runs.</p>
   */
  inline const Aws::Vector<Run>& GetRuns() const { return m_runs; }
  template <typename RunsT = Aws::Vector<Run>>
  void SetRuns(RunsT&& value) {
    m_runsHasBeenSet = true;
    m_runs = std::forward<RunsT>(value);
  }
  template <typename RunsT = Aws::Vector<Run>>
  ListRunsResult& WithRuns(RunsT&& value) {
    SetRuns(std::forward<RunsT>(value));
    return *this;
  }
  template <typename RunsT = Run>
  ListRunsResult& AddRuns(RunsT&& value) {
    m_runsHasBeenSet = true;
    m_runs.emplace_back(std::forward<RunsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the number of items that are returned is significantly large, this is an
   * identifier that is also returned. It can be used in a subsequent call to this
   * operation to return the next set of items in the list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListRunsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListRunsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Run> m_runs;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_runsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DeviceFarm
}  // namespace Aws
