# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepGProp module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_brepgprop.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepGProp
else:
    import _BRepGProp

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepGProp.delete_SwigPyIterator

    def value(self):
        return _BRepGProp.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepGProp.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepGProp.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepGProp.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepGProp.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepGProp.SwigPyIterator_copy(self)

    def next(self):
        return _BRepGProp.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepGProp.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepGProp.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepGProp.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepGProp.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepGProp.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepGProp.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepGProp.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepGProp.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepGProp.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepGProp:
_BRepGProp.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepGProp.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.GProp
import OCC.Core.TColgp
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor

from enum import IntEnum
from OCC.Core.Exception import *



class brepgprop(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def LinearProperties(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        LProps: GProp_GProps
        SkipShared: bool (optional, default to Standard_False)
        UseTriangulation: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes the linear global properties of the shape s, i.e. the global properties induced by each edge of the shape s, and brings them together with the global properties still retained by the framework lprops. if the current system of lprops was empty, its global properties become equal to the linear global properties of s. for this computation no linear density is attached to the edges. so, for example, the added mass corresponds to the sum of the lengths of the edges of s. the density of the composed systems, i.e. that of each component of the current system of lprops, and that of s which is considered to be equal to 1, must be coherent. note that this coherence cannot be checked. you are advised to use a separate framework for each density, and then to bring these frameworks together into a global one. the point relative to which the inertia of the system is computed is the reference point of the framework lprops. note: if your programming ensures that the framework lprops retains only linear global properties (brought together for example, by the function linearproperties) for objects the density of which is equal to 1 (or is not defined), the function mass will return the total length of edges of the system analysed by lprops. warning no check is performed to verify that the shape s retains truly linear properties. if s is simply a vertex, it is not considered to present any additional global properties. skipshared is a special flag, which allows taking in calculation shared topological entities or not. for ex., if skipshared = true, edges, shared by two or more faces, are taken into calculation only once. if we have cube with sizes 1, 1, 1, its linear properties = 12 for skipedges = true and 24 for skipedges = false. usetriangulation is a special flag, which defines preferable source of geometry data. if usetriangulation = standard_false, exact geometry objects (curves) are used, otherwise polygons of triangulation are used first.

        """
        return _BRepGProp.brepgprop_LinearProperties(*args)

    @staticmethod
    def SurfaceProperties(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        SProps: GProp_GProps
        SkipShared: bool (optional, default to Standard_False)
        UseTriangulation: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Computes the surface global properties of the shape s, i.e. the global properties induced by each face of the shape s, and brings them together with the global properties still retained by the framework sprops. if the current system of sprops was empty, its global properties become equal to the surface global properties of s. for this computation, no surface density is attached to the faces. consequently, the added mass corresponds to the sum of the areas of the faces of s. the density of the component systems, i.e. that of each component of the current system of sprops, and that of s which is considered to be equal to 1, must be coherent. note that this coherence cannot be checked. you are advised to use a framework for each different value of density, and then to bring these frameworks together into a global one. the point relative to which the inertia of the system is computed is the reference point of the framework sprops. note: if your programming ensures that the framework sprops retains only surface global properties, brought together, for example, by the function surfaceproperties, for objects the density of which is equal to 1 (or is not defined), the function mass will return the total area of faces of the system analysed by sprops. warning no check is performed to verify that the shape s retains truly surface properties. if s is simply a vertex, an edge or a wire, it is not considered to present any additional global properties. skipshared is a special flag, which allows taking in calculation shared topological entities or not. for ex., if skipshared = true, faces, shared by two or more shells, are taken into calculation only once. usetriangulation is a special flag, which defines preferable source of geometry data. if usetriangulation = standard_false, exact geometry objects (surfaces) are used, otherwise face triangulations are used first.

        Parameters
        ----------
        S: TopoDS_Shape
        SProps: GProp_GProps
        Eps: float
        SkipShared: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Updates <sprops> with the shape <s>, that contains its principal properties. the surface properties of all the faces in <s> are computed. adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (area) for each face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration. method returns estimation of relative error reached for whole shape. warning: if eps > 0.001 algorithm performs non-adaptive integration. skipshared is a special flag, which allows taking in calculation shared topological entities or not for ex., if skipshared = true, faces, shared by two or more shells, are taken into calculation only once.

        """
        return _BRepGProp.brepgprop_SurfaceProperties(*args)

    @staticmethod
    def VolumeProperties(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        VProps: GProp_GProps
        OnlyClosed: bool (optional, default to Standard_False)
        SkipShared: bool (optional, default to Standard_False)
        UseTriangulation: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        //! computes the global volume properties of the solid s, and brings them together with the global properties still retained by the framework vprops. if the current system of vprops was empty, its global properties become equal to the global properties of s for volume. for this computation, no volume density is attached to the solid. consequently, the added mass corresponds to the volume of s. the density of the component systems, i.e. that of each component of the current system of vprops, and that of s which is considered to be equal to 1, must be coherent to each other. note that this coherence cannot be checked. you are advised to use a separate framework for each density, and then to bring these frameworks together into a global one. the point relative to which the inertia of the system is computed is the reference point of the framework vprops. note: if your programming ensures that the framework vprops retains only global properties of volume (brought together for example, by the function volumeproperties) for objects the density of which is equal to 1 (or is not defined), the function mass will return the total volume of the solids of the system analysed by vprops. warning the shape s must represent an object whose global volume properties can be computed. it may be a finite solid, or a series of finite solids all oriented in a coherent way. nonetheless, s must be exempt of any free boundary. note that these conditions of coherence are not checked by this algorithm, and results will be false if they are not respected. skipshared a is special flag, which allows taking in calculation shared topological entities or not. for ex., if skipshared = true, the volumes formed by the equal (the same tshape, location and orientation) faces are taken into calculation only once. usetriangulation is a special flag, which defines preferable source of geometry data. if usetriangulation = standard_false, exact geometry objects (surfaces) are used, otherwise face triangulations are used first.

        Parameters
        ----------
        S: TopoDS_Shape
        VProps: GProp_GProps
        Eps: float
        OnlyClosed: bool (optional, default to Standard_False)
        SkipShared: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Updates <vprops> with the shape <s>, that contains its principal properties. the volume properties of all the forward and reversed faces in <s> are computed. if onlyclosed is true then computed faces must belong to closed shells. adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for each face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration. method returns estimation of relative error reached for whole shape. warning: if eps > 0.001 algorithm performs non-adaptive integration. skipshared is a special flag, which allows taking in calculation shared topological entities or not. for ex., if skipshared = true, the volumes formed by the equal (the same tshape, location and orientation) faces are taken into calculation only once.

        """
        return _BRepGProp.brepgprop_VolumeProperties(*args)

    @staticmethod
    def VolumePropertiesGK(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        VProps: GProp_GProps
        Eps: float (optional, default to 0.001)
        OnlyClosed: bool (optional, default to Standard_False)
        IsUseSpan: bool (optional, default to Standard_False)
        CGFlag: bool (optional, default to Standard_False)
        IFlag: bool (optional, default to Standard_False)
        SkipShared: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Updates <vprops> with the shape <s>, that contains its principal properties. the volume properties of all the forward and reversed faces in <s> are computed. if onlyclosed is true then computed faces must belong to closed shells. adaptive 2d gauss integration is used. parameter isusespan says if it is necessary to define spans on a face. this option has an effect only for bspline faces. parameter eps sets maximal relative error of computed property for each face. error is delivered by the adaptive gauss-kronrod method of integral computation that is used for properties computation. method returns estimation of relative error reached for whole shape. returns negative value if the computation is failed. skipshared is a special flag, which allows taking in calculation shared topological entities or not. for ex., if skipshared = true, the volumes formed by the equal (the same tshape, location and orientation) faces are taken into calculation only once.

        Parameters
        ----------
        S: TopoDS_Shape
        VProps: GProp_GProps
        thePln: gp_Pln
        Eps: float (optional, default to 0.001)
        OnlyClosed: bool (optional, default to Standard_False)
        IsUseSpan: bool (optional, default to Standard_False)
        CGFlag: bool (optional, default to Standard_False)
        IFlag: bool (optional, default to Standard_False)
        SkipShared: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.brepgprop_VolumePropertiesGK(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepGProp.brepgprop_swiginit(self, _BRepGProp.new_brepgprop())
    __swig_destroy__ = _BRepGProp.delete_brepgprop

# Register brepgprop in _BRepGProp:
_BRepGProp.brepgprop_swigregister(brepgprop)
class BRepGProp_Cinert(OCC.Core.GProp.GProp_GProps):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: BRepAdaptor_Curve
        CLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepGProp.BRepGProp_Cinert_swiginit(self, _BRepGProp.new_BRepGProp_Cinert(*args))

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Cinert_Perform(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        CLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Cinert_SetLocation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Cinert

# Register BRepGProp_Cinert in _BRepGProp:
_BRepGProp.BRepGProp_Cinert_swigregister(BRepGProp_Cinert)
class BRepGProp_Domain(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Constructor. initializes the domain with the face.

        """
        _BRepGProp.BRepGProp_Domain_swiginit(self, _BRepGProp.new_BRepGProp_Domain(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initializes the domain with the face.
        Return
        -------
        None

        Description
        -----------
        Initializes the exploration with the face already set.

        """
        return _BRepGProp.BRepGProp_Domain_Init(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is another arc of curve in the list.

        """
        return _BRepGProp.BRepGProp_Domain_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets the index of the arc iterator to the next arc of curve.

        """
        return _BRepGProp.BRepGProp_Domain_Next(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns the current edge.

        """
        return _BRepGProp.BRepGProp_Domain_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Domain

# Register BRepGProp_Domain in _BRepGProp:
_BRepGProp.BRepGProp_Domain_swigregister(BRepGProp_Domain)
class BRepGProp_EdgeTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def D1(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve
        U: float
        P: gp_Pnt
        V1: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Returns the point of parameter u and the first derivative at this point.

        """
        return _BRepGProp.BRepGProp_EdgeTool_D1(*args)

    @staticmethod
    def FirstParameter(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve

        Return
        -------
        float

        Description
        -----------
        Returns the parametric value of the start point of the curve. the curve is oriented from the start point to the end point.

        """
        return _BRepGProp.BRepGProp_EdgeTool_FirstParameter(*args)

    @staticmethod
    def IntegrationOrder(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve

        Return
        -------
        int

        Description
        -----------
        Returns the number of gauss points required to do the integration with a good accuracy using the gauss method. for a polynomial curve of degree n the maxima of accuracy is obtained with an order of integration equal to 2*n-1.

        """
        return _BRepGProp.BRepGProp_EdgeTool_IntegrationOrder(*args)

    @staticmethod
    def Intervals(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve
        T: TColStd_Array1OfReal
        S: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Stores in <t> the parameters bounding the intervals of continuity <s>. //! the array must provide enough room to accommodate for the parameters. i.e. t.length() > nbintervals().

        """
        return _BRepGProp.BRepGProp_EdgeTool_Intervals(*args)

    @staticmethod
    def LastParameter(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve

        Return
        -------
        float

        Description
        -----------
        Returns the parametric value of the end point of the curve. the curve is oriented from the start point to the end point.

        """
        return _BRepGProp.BRepGProp_EdgeTool_LastParameter(*args)

    @staticmethod
    def NbIntervals(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve
        S: GeomAbs_Shape

        Return
        -------
        int

        Description
        -----------
        Returns the number of intervals for continuity <s>. may be one if continuity(me) >= <s>.

        """
        return _BRepGProp.BRepGProp_EdgeTool_NbIntervals(*args)

    @staticmethod
    def Value(*args):
        r"""

        Parameters
        ----------
        C: BRepAdaptor_Curve
        U: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point of parameter u on the loaded curve.

        """
        return _BRepGProp.BRepGProp_EdgeTool_Value(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepGProp.BRepGProp_EdgeTool_swiginit(self, _BRepGProp.new_BRepGProp_EdgeTool())
    __swig_destroy__ = _BRepGProp.delete_BRepGProp_EdgeTool

# Register BRepGProp_EdgeTool in _BRepGProp:
_BRepGProp.BRepGProp_EdgeTool_swigregister(BRepGProp_EdgeTool)
class BRepGProp_Face(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        IsUseSpan: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. initializes the object with a flag isusespan that says if it is necessary to define spans on a face. this option has an effect only for bspline faces. spans are returned by the methods getuknots and gettknots.

        Parameters
        ----------
        F: TopoDS_Face
        IsUseSpan: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. initializes the object with the face and the flag isusespan that says if it is necessary to define spans on a face. this option has an effect only for bspline faces. spans are returned by the methods getuknots and gettknots.

        """
        _BRepGProp.BRepGProp_Face_swiginit(self, _BRepGProp.new_BRepGProp_Face(*args))

    def Bounds(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        U1: float
        U2: float
        V1: float
        V2: float

        Description
        -----------
        Returns the parametric bounds of the face.

        """
        return _BRepGProp.BRepGProp_Face_Bounds(self, *args)

    def D12d(self, *args):
        r"""

        Parameters
        ----------
        U: float
        P: gp_Pnt2d
        V1: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Returns the point of parameter u and the first derivative at this point of a boundary curve.

        """
        return _BRepGProp.BRepGProp_Face_D12d(self, *args)

    def FirstParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parametric value of the start point of the current arc of curve.

        """
        return _BRepGProp.BRepGProp_Face_FirstParameter(self, *args)

    def GetFace(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Returns the topods face.

        """
        return _BRepGProp.BRepGProp_Face_GetFace(self, *args)

    def GetTKnots(self, *args):
        r"""

        Parameters
        ----------
        theTMin: float
        theTMax: float
        theTKnots: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns an array of combination of t knots of the arc and v knots of the face. the first and last elements of the array will be thetmin and thetmax. the middle elements will be the knots of the arc and the values of parameters of arc on which the value points have v coordinates close to v knots of face. all the parameter will be greater then thetmin and lower then thetmax in increasing order. if the face is not a bspline, the array initialized with thetmin and thetmax only.

        """
        return _BRepGProp.BRepGProp_Face_GetTKnots(self, *args)

    def GetUKnots(self, *args):
        r"""

        Parameters
        ----------
        theUMin: float
        theUMax: float
        theUKnots: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        Returns an array of u knots of the face. the first and last elements of the array will be theumin and theumax. the middle elements will be the u knots of the face greater then theumin and lower then theumax in increasing order. if the face is not a bspline, the array initialized with theumin and theumax only.

        """
        return _BRepGProp.BRepGProp_Face_GetUKnots(self, *args)

    def IntegrationOrder(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points required to do the integration along the parameter of curve.

        """
        return _BRepGProp.BRepGProp_Face_IntegrationOrder(self, *args)

    def LIntOrder(self, *args):
        r"""

        Parameters
        ----------
        Eps: float

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_LIntOrder(self, *args)

    def LIntSubs(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_LIntSubs(self, *args)

    def LKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_LKnots(self, *args)

    def LastParameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parametric value of the end point of the current arc of curve.

        """
        return _BRepGProp.BRepGProp_Face_LastParameter(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Loading the boundary arc. returns false if edge has no p-curve.

        Parameters
        ----------
        IsFirstParam: bool
        theIsoType: GeomAbs_IsoType

        Return
        -------
        None

        Description
        -----------
        Loading the boundary arc. this arc is either a top, bottom, left or right bound of a uv rectangle in which the parameters of surface are defined. if isfirstparam is equal to standard_true, the face is initialized by either left of bottom bound. otherwise it is initialized by the top or right one. if theisotype is equal to geomabs_isou, the face is initialized with either left or right bound. otherwise - with either top or bottom one.

        """
        return _BRepGProp.BRepGProp_Face_Load(self, *args)

    def NaturalRestriction(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the face is not trimmed.

        """
        return _BRepGProp.BRepGProp_Face_NaturalRestriction(self, *args)

    def Normal(self, *args):
        r"""

        Parameters
        ----------
        U: float
        V: float
        P: gp_Pnt
        VNor: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Computes the point of parameter u, v on the face <s> and the normal to the face at this point.

        """
        return _BRepGProp.BRepGProp_Face_Normal(self, *args)

    def SIntOrder(self, *args):
        r"""

        Parameters
        ----------
        Eps: float

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_SIntOrder(self, *args)

    def SUIntSubs(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_SUIntSubs(self, *args)

    def SVIntSubs(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_SVIntSubs(self, *args)

    def UIntegrationOrder(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points required to do the integration in the u parametric direction with a good accuracy.

        """
        return _BRepGProp.BRepGProp_Face_UIntegrationOrder(self, *args)

    def UKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_UKnots(self, *args)

    def VIntegrationOrder(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_VIntegrationOrder(self, *args)

    def VKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Face_VKnots(self, *args)

    def Value2d(self, *args):
        r"""

        Parameters
        ----------
        U: float

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the value of the boundary curve of the face.

        """
        return _BRepGProp.BRepGProp_Face_Value2d(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Face

# Register BRepGProp_Face in _BRepGProp:
_BRepGProp.BRepGProp_Face_swigregister(BRepGProp_Face)
class BRepGProp_Gauss(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Vinert = _BRepGProp.BRepGProp_Gauss_Vinert
    Sinert = _BRepGProp.BRepGProp_Gauss_Sinert


    class BRepGProp_GaussType(IntEnum):
    	Vinert = 0
    	Sinert = 1
    Vinert = BRepGProp_GaussType.Vinert
    Sinert = BRepGProp_GaussType.Sinert


    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theType: BRepGProp_GaussType

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _BRepGProp.BRepGProp_Gauss_swiginit(self, _BRepGProp.new_BRepGProp_Gauss(*args))

    __repr__ = _dumps_object

    @methodnotwrapped
    def Compute(self):
    	pass

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Gauss

# Register BRepGProp_Gauss in _BRepGProp:
_BRepGProp.BRepGProp_Gauss_swigregister(BRepGProp_Gauss)
class BRepGProp_MeshCinert(OCC.Core.GProp.GProp_GProps):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepGProp.BRepGProp_MeshCinert_swiginit(self, _BRepGProp.new_BRepGProp_MeshCinert(*args))

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theNodes: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of of polylines represented by set of points.

        """
        return _BRepGProp.BRepGProp_MeshCinert_Perform(self, *args)

    @staticmethod
    def PreparePolygon(*args):
        r"""

        Parameters
        ----------
        theE: TopoDS_Edge
        thePolyg: TColgp_HArray1OfPnt

        Return
        -------
        None

        Description
        -----------
        Prepare set of 3d points on base of any available edge polygons: 3d polygon, polygon on triangulation, 2d polygon on surface if edge has no polygons, array thepolyg is left unchanged.

        """
        return _BRepGProp.BRepGProp_MeshCinert_PreparePolygon(*args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        CLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_MeshCinert_SetLocation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_MeshCinert

# Register BRepGProp_MeshCinert in _BRepGProp:
_BRepGProp.BRepGProp_MeshCinert_swigregister(BRepGProp_MeshCinert)
class BRepGProp_Sinert(OCC.Core.GProp.GProp_GProps):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        SLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        SLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Builds a sinert to evaluate the global properties of the face <s>. if isnaturalrestriction is true the domain of s is defined with the natural bounds, else it defined with an iterator of edge from topods (see domaintool from gprop).

        Parameters
        ----------
        S: BRepGProp_Face
        SLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        SLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepGProp.BRepGProp_Sinert_swiginit(self, _BRepGProp.new_BRepGProp_Sinert(*args))

    def GetEpsilon(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        If previously used method contained eps parameter get actual relative error of the computation, else return 1.0.

        """
        return _BRepGProp.BRepGProp_Sinert_GetEpsilon(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        S: BRepGProp_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Sinert_Perform(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        SLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Sinert_SetLocation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Sinert

# Register BRepGProp_Sinert in _BRepGProp:
_BRepGProp.BRepGProp_Sinert_swigregister(BRepGProp_Sinert)
class BRepGProp_TFunction(OCC.Core.math.math_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theVertex: gp_Pnt
        IsByPoint: bool
        theCoeffs: float *
        theUMin: float
        theTolerance: float

        Return
        -------
        None

        Description
        -----------
        Constructor. initializes the function with the face, the location point, the flag isbypoint, the coefficients thecoeff that have different meaning depending on the value of isbypoint. the last two parameters are theumin - the lower bound of the inner integral. this value is fixed for any integral. and the value of tolerance of inner integral computation. if isbypoint is equal to standard_true, the number of the coefficients is equal to 3 and they represent x, y and z coordinates (thecoeff[0], thecoeff[1] and thecoeff[2] correspondingly) of the shift if the inertia is computed with respect to the point different then the location. if isbypoint is equal to standard_false, the number of the coefficients is 4 and they represent the combination of plane parameters and shift values.

        """
        _BRepGProp.BRepGProp_TFunction_swiginit(self, _BRepGProp.new_BRepGProp_TFunction(*args))

    def AbsolutError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the absolut reached error of all values computation since the last call of getstatenumber method.

        """
        return _BRepGProp.BRepGProp_TFunction_AbsolutError(self, *args)

    def ErrorReached(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the relative reached error of all values computation since the last call of getstatenumber method.

        """
        return _BRepGProp.BRepGProp_TFunction_ErrorReached(self, *args)

    def Init(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_TFunction_Init(self, *args)

    def SetNbKronrodPoints(self, *args):
        r"""

        Parameters
        ----------
        theNbPoints: int

        Return
        -------
        None

        Description
        -----------
        Setting the expected number of kronrod points for the outer integral computation. this number is required for computation of a value of tolerance for inner integral computation. after getstatenumber method call, this number is recomputed by the same law as in math_kronrodsingleintegration, i.e. next number of points is equal to the current number plus a square root of the current number. if the law in math_kronrodsingleintegration is changed, the modification algo should be modified accordingly.

        """
        return _BRepGProp.BRepGProp_TFunction_SetNbKronrodPoints(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        aTol: float

        Return
        -------
        None

        Description
        -----------
        Setting the tolerance for inner integration.

        """
        return _BRepGProp.BRepGProp_TFunction_SetTolerance(self, *args)

    def SetValueType(self, *args):
        r"""

        Parameters
        ----------
        aType: GProp_ValueType

        Return
        -------
        None

        Description
        -----------
        Setting the type of the value to be returned. this parameter is directly passed to the ufunction.

        """
        return _BRepGProp.BRepGProp_TFunction_SetValueType(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_TFunction

# Register BRepGProp_TFunction in _BRepGProp:
_BRepGProp.BRepGProp_TFunction_swigregister(BRepGProp_TFunction)
class BRepGProp_UFunction(OCC.Core.math.math_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theVertex: gp_Pnt
        IsByPoint: bool
        theCoeffs: float *

        Return
        -------
        None

        Description
        -----------
        Constructor. initializes the function with the face, the location point, the flag isbypoint and the coefficients thecoeff that have different meaning depending on the value of isbypoint. if isbypoint is equal to standard_true, the number of the coefficients is equal to 3 and they represent x, y and z coordinates (thecoeff[0], thecoeff[1] and thecoeff[2] correspondingly) of the shift, if the inertia is computed with respect to the point different then the location. if isbypoint is equal to standard_false, the number of the coefficients is 4 and they represent the combination of plane parameters and shift values.

        """
        _BRepGProp.BRepGProp_UFunction_swiginit(self, _BRepGProp.new_BRepGProp_UFunction(*args))

    def SetVParam(self, *args):
        r"""

        Parameters
        ----------
        theVParam: float

        Return
        -------
        None

        Description
        -----------
        Setting the v parameter that is constant during the integral computation.

        """
        return _BRepGProp.BRepGProp_UFunction_SetVParam(self, *args)

    def SetValueType(self, *args):
        r"""

        Parameters
        ----------
        theType: GProp_ValueType

        Return
        -------
        None

        Description
        -----------
        Setting the type of the value to be returned.

        """
        return _BRepGProp.BRepGProp_UFunction_SetValueType(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_UFunction

# Register BRepGProp_UFunction in _BRepGProp:
_BRepGProp.BRepGProp_UFunction_swigregister(BRepGProp_UFunction)
class BRepGProp_Vinert(OCC.Core.GProp.GProp_GProps):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface <s> and the point vlocation. s can be closed the method is quick and its precision is enough for many cases of analytical surfaces. non-adaptive 2d gauss integration with predefined numbers of gauss points is used. numbers of points depend on types of surfaces and curves. error of the computation is not calculated.

        Parameters
        ----------
        S: BRepGProp_Face
        VLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface <s> and the point vlocation. s can be closed adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration.

        Parameters
        ----------
        S: BRepGProp_Face
        O: gp_Pnt
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the point vlocation. the method is quick and its precision is enough for many cases of analytical surfaces. non-adaptive 2d gauss integration with predefined numbers of gauss points is used. numbers of points depend on types of surfaces and curves. error of the computation is not calculated.

        Parameters
        ----------
        S: BRepGProp_Face
        O: gp_Pnt
        VLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the point vlocation. adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration. warning: if eps > 0.001 algorithm performs non-adaptive integration.

        Parameters
        ----------
        S: BRepGProp_Face
        Pl: gp_Pln
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the plane pln. the method is quick and its precision is enough for many cases of analytical surfaces. non-adaptive 2d gauss integration with predefined numbers of gauss points is used. numbers of points depend on types of surfaces and curves. error of the computation is not calculated.

        Parameters
        ----------
        S: BRepGProp_Face
        Pl: gp_Pln
        VLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the plane pln. adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration. warning: if eps > 0.001 algorithm performs non-adaptive integration.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface <s> and the point vlocation. s can be closed the method is quick and its precision is enough for many cases of analytical surfaces. non-adaptive 2d gauss integration with predefined numbers of gauss points is used. numbers of points depend on types of surfaces and curves. error of the computation is not calculated.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        VLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface <s> and the point vlocation. s can be closed adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        O: gp_Pnt
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the point vlocation. the method is quick and its precision is enough for many cases of analytical surfaces. non-adaptive 2d gauss integration with predefined numbers of gauss points is used. numbers of points depend on types of surfaces and curves. error of the computation is not calculated.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        O: gp_Pnt
        VLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the point vlocation. adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration. warning: if eps > 0.001 algorithm performs non-adaptive integration.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        Pl: gp_Pln
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the plane pln. the method is quick and its precision is enough for many cases of analytical surfaces. non-adaptive 2d gauss integration with predefined numbers of gauss points is used. numbers of points depend on types of surfaces and curves. error of the computation is not calculated.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        Pl: gp_Pln
        VLocation: gp_Pnt
        Eps: float

        Return
        -------
        None

        Description
        -----------
        Computes the global properties of the region of 3d space delimited with the surface <s> and the plane pln. adaptive 2d gauss integration is used. parameter eps sets maximal relative error of computed mass (volume) for face. error is calculated as abs((m(i+1)-m(i))/m(i+1)), m(i+1) and m(i) are values for two successive steps of adaptive integration. warning: if eps > 0.001 algorithm performs non-adaptive integration.

        """
        _BRepGProp.BRepGProp_Vinert_swiginit(self, _BRepGProp.new_BRepGProp_Vinert(*args))

    def GetEpsilon(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        If previously used methods containe eps parameter gets actual relative error of the computation, else returns 1.0.

        """
        return _BRepGProp.BRepGProp_Vinert_GetEpsilon(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        S: BRepGProp_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        O: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        O: gp_Pnt
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        Pl: gp_Pln

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        Pl: gp_Pln
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        O: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        O: gp_Pnt
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        Pl: gp_Pln

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: BRepGProp_Face
        D: BRepGProp_Domain
        Pl: gp_Pln
        Eps: float

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Vinert_Perform(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        VLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepGProp.BRepGProp_Vinert_SetLocation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Vinert

# Register BRepGProp_Vinert in _BRepGProp:
_BRepGProp.BRepGProp_Vinert_swigregister(BRepGProp_Vinert)
class BRepGProp_VinertGK(OCC.Core.GProp.GProp_GProps):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theLocation: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. computes the global properties of a region of 3d space delimited with the naturally restricted surface and the point vlocation.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        thePoint: gp_Pnt
        theLocation: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. computes the global properties of a region of 3d space delimited with the naturally restricted surface and the point vlocation. the inertia is computed with respect to thepoint.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theDomain: BRepGProp_Domain
        theLocation: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. computes the global properties of a region of 3d space delimited with the surface bounded by the domain and the point vlocation.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theDomain: BRepGProp_Domain
        thePoint: gp_Pnt
        theLocation: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. computes the global properties of a region of 3d space delimited with the surface bounded by the domain and the point vlocation. the inertia is computed with respect to thepoint.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        thePlane: gp_Pln
        theLocation: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. computes the global properties of a region of 3d space delimited with the naturally restricted surface and the plane.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theDomain: BRepGProp_Domain
        thePlane: gp_Pln
        theLocation: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor. computes the global properties of a region of 3d space delimited with the surface bounded by the domain and the plane.

        """
        _BRepGProp.BRepGProp_VinertGK_swiginit(self, _BRepGProp.new_BRepGProp_VinertGK(*args))

    def GetErrorReached(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the relative reached computation error.

        """
        return _BRepGProp.BRepGProp_VinertGK_GetErrorReached(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the naturally restricted surface and the point vlocation.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        thePoint: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the naturally restricted surface and the point vlocation. the inertia is computed with respect to thepoint.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theDomain: BRepGProp_Domain
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface bounded by the domain and the point vlocation.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theDomain: BRepGProp_Domain
        thePoint: gp_Pnt
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface bounded by the domain and the point vlocation. the inertia is computed with respect to thepoint.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        thePlane: gp_Pln
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the naturally restricted surface and the plane.

        Parameters
        ----------
        theSurface: BRepGProp_Face
        theDomain: BRepGProp_Domain
        thePlane: gp_Pln
        theTolerance: float (optional, default to 0.001)
        theCGFlag: bool (optional, default to Standard_False)
        theIFlag: bool (optional, default to Standard_False)

        Return
        -------
        float

        Description
        -----------
        Computes the global properties of a region of 3d space delimited with the surface bounded by the domain and the plane.

        """
        return _BRepGProp.BRepGProp_VinertGK_Perform(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLocation: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Sets the vertex that delimit 3d closed region of space.

        """
        return _BRepGProp.BRepGProp_VinertGK_SetLocation(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def GetAbsolutError(self):
    	pass

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_VinertGK

# Register BRepGProp_VinertGK in _BRepGProp:
_BRepGProp.BRepGProp_VinertGK_swigregister(BRepGProp_VinertGK)

@classnotwrapped
class BRepGProp_MeshProps:
	pass





@deprecated
def brepgprop_LinearProperties(*args):
	return brepgprop.LinearProperties(*args)

@deprecated
def brepgprop_SurfaceProperties(*args):
	return brepgprop.SurfaceProperties(*args)

@deprecated
def brepgprop_SurfaceProperties(*args):
	return brepgprop.SurfaceProperties(*args)

@deprecated
def brepgprop_VolumeProperties(*args):
	return brepgprop.VolumeProperties(*args)

@deprecated
def brepgprop_VolumeProperties(*args):
	return brepgprop.VolumeProperties(*args)

@deprecated
def brepgprop_VolumePropertiesGK(*args):
	return brepgprop.VolumePropertiesGK(*args)

@deprecated
def brepgprop_VolumePropertiesGK(*args):
	return brepgprop.VolumePropertiesGK(*args)

@deprecated
def BRepGProp_EdgeTool_D1(*args):
	return BRepGProp_EdgeTool.D1(*args)

@deprecated
def BRepGProp_EdgeTool_FirstParameter(*args):
	return BRepGProp_EdgeTool.FirstParameter(*args)

@deprecated
def BRepGProp_EdgeTool_IntegrationOrder(*args):
	return BRepGProp_EdgeTool.IntegrationOrder(*args)

@deprecated
def BRepGProp_EdgeTool_Intervals(*args):
	return BRepGProp_EdgeTool.Intervals(*args)

@deprecated
def BRepGProp_EdgeTool_LastParameter(*args):
	return BRepGProp_EdgeTool.LastParameter(*args)

@deprecated
def BRepGProp_EdgeTool_NbIntervals(*args):
	return BRepGProp_EdgeTool.NbIntervals(*args)

@deprecated
def BRepGProp_EdgeTool_Value(*args):
	return BRepGProp_EdgeTool.Value(*args)

@deprecated
def BRepGProp_MeshCinert_PreparePolygon(*args):
	return BRepGProp_MeshCinert.PreparePolygon(*args)



