/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.conversation;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.SearchHit;

public class Interaction
implements Writeable,
ToXContentObject {
    private String id;
    private Instant createTime;
    private String conversationId;
    private String input;
    private String promptTemplate;
    private String response;
    private String origin;
    private String additionalInfo;

    public static Interaction fromMap(String id, Map<String, Object> fields) {
        Instant createTime = Instant.parse((String)fields.get("create_time"));
        String conversationId = (String)fields.get("conversation_id");
        String input = (String)fields.get("input");
        String promptTemplate = (String)fields.get("prompt_template");
        String response = (String)fields.get("response");
        String origin = (String)fields.get("origin");
        String additionalInfo = (String)fields.get("additional_info");
        return new Interaction(id, createTime, conversationId, input, promptTemplate, response, origin, additionalInfo);
    }

    public static Interaction fromSearchHit(SearchHit hit) {
        String id = hit.getId();
        return Interaction.fromMap(id, hit.getSourceAsMap());
    }

    public static Interaction fromStream(StreamInput in) throws IOException {
        String id = in.readString();
        Instant createTime = in.readInstant();
        String conversationId = in.readString();
        String input = in.readString();
        String promptTemplate = in.readString();
        String response = in.readString();
        String origin = in.readString();
        String additionalInfo = in.readOptionalString();
        return new Interaction(id, createTime, conversationId, input, promptTemplate, response, origin, additionalInfo);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeInstant(this.createTime);
        out.writeString(this.conversationId);
        out.writeString(this.input);
        out.writeString(this.promptTemplate);
        out.writeString(this.response);
        out.writeString(this.origin);
        out.writeOptionalString(this.additionalInfo);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("conversation_id", this.conversationId);
        builder.field("interaction_id", this.id);
        builder.field("create_time", (Object)this.createTime);
        builder.field("input", this.input);
        builder.field("prompt_template", this.promptTemplate);
        builder.field("response", this.response);
        builder.field("origin", this.origin);
        if (this.additionalInfo != null) {
            builder.field("additional_info", this.additionalInfo);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        return other instanceof Interaction && ((Interaction)other).id.equals(this.id) && ((Interaction)other).conversationId.equals(this.conversationId) && ((Interaction)other).createTime.equals(this.createTime) && ((Interaction)other).input.equals(this.input) && ((Interaction)other).promptTemplate.equals(this.promptTemplate) && ((Interaction)other).response.equals(this.response) && ((Interaction)other).origin.equals(this.origin) && (((Interaction)other).additionalInfo == null && this.additionalInfo == null || ((Interaction)other).additionalInfo.equals(this.additionalInfo));
    }

    public String toString() {
        return "Interaction{id=" + this.id + ",cid=" + this.conversationId + ",create_time=" + this.createTime + ",origin=" + this.origin + ",input=" + this.input + ",promt_template=" + this.promptTemplate + ",response=" + this.response + ",additional_info=" + this.additionalInfo + "}";
    }

    @Generated
    public static InteractionBuilder builder() {
        return new InteractionBuilder();
    }

    @Generated
    public Interaction(String id, Instant createTime, String conversationId, String input, String promptTemplate, String response, String origin, String additionalInfo) {
        this.id = id;
        this.createTime = createTime;
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public static class InteractionBuilder {
        @Generated
        private String id;
        @Generated
        private Instant createTime;
        @Generated
        private String conversationId;
        @Generated
        private String input;
        @Generated
        private String promptTemplate;
        @Generated
        private String response;
        @Generated
        private String origin;
        @Generated
        private String additionalInfo;

        @Generated
        InteractionBuilder() {
        }

        @Generated
        public InteractionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public InteractionBuilder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public InteractionBuilder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @Generated
        public InteractionBuilder input(String input) {
            this.input = input;
            return this;
        }

        @Generated
        public InteractionBuilder promptTemplate(String promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        @Generated
        public InteractionBuilder response(String response) {
            this.response = response;
            return this;
        }

        @Generated
        public InteractionBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public InteractionBuilder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Generated
        public Interaction build() {
            return new Interaction(this.id, this.createTime, this.conversationId, this.input, this.promptTemplate, this.response, this.origin, this.additionalInfo);
        }

        @Generated
        public String toString() {
            return "Interaction.InteractionBuilder(id=" + this.id + ", createTime=" + this.createTime + ", conversationId=" + this.conversationId + ", input=" + this.input + ", promptTemplate=" + this.promptTemplate + ", response=" + this.response + ", origin=" + this.origin + ", additionalInfo=" + this.additionalInfo + ")";
        }
    }
}

