/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage.querybuilder;

import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

public class SeriesSelectionQueryBuilder {
    public static String build(String metricName, Expression filterCondition) {
        SeriesSelectionExpressionNodeVisitor seriesSelectionExpressionNodeVisitor;
        String selectorQuery;
        if (filterCondition != null && (selectorQuery = (String)filterCondition.accept((ExpressionNodeVisitor)(seriesSelectionExpressionNodeVisitor = new SeriesSelectionExpressionNodeVisitor()), null)) != null) {
            return metricName + "{" + selectorQuery + "}";
        }
        return metricName;
    }

    @Generated
    public SeriesSelectionQueryBuilder() {
    }

    static class SeriesSelectionExpressionNodeVisitor
    extends ExpressionNodeVisitor<String, Object> {
        SeriesSelectionExpressionNodeVisitor() {
        }

        public String visitFunction(FunctionExpression func, Object context) {
            if (BuiltinFunctionName.AND.getName().equals((Object)func.getFunctionName())) {
                return func.getArguments().stream().map(arg -> this.visitFunction((FunctionExpression)arg, context)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" , "));
            }
            if ((BuiltinFunctionName.LTE.getName().equals((Object)func.getFunctionName()) || BuiltinFunctionName.GTE.getName().equals((Object)func.getFunctionName()) || BuiltinFunctionName.LESS.getName().equals((Object)func.getFunctionName()) || BuiltinFunctionName.GREATER.getName().equals((Object)func.getFunctionName())) && ((ReferenceExpression)func.getArguments().get(0)).getAttr().equals("@timestamp")) {
                return null;
            }
            if (BuiltinFunctionName.EQUAL.getName().equals((Object)func.getFunctionName())) {
                return func.getArguments().get(0) + func.getFunctionName().getFunctionName() + func.getArguments().get(1);
            }
            throw new RuntimeException(String.format("Prometheus Datasource doesn't support %s in where command.", func.getFunctionName().getFunctionName()));
        }
    }
}

