// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/comment_service.proto

#include "google/cloud/support/v2/comment_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace support_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CommentServiceConnectionIdempotencyPolicy::
    ~CommentServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<CommentServiceConnectionIdempotencyPolicy>
CommentServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CommentServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency CommentServiceConnectionIdempotencyPolicy::ListComments(
    google::cloud::support::v2::ListCommentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CommentServiceConnectionIdempotencyPolicy::CreateComment(
    google::cloud::support::v2::CreateCommentRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CommentServiceConnectionIdempotencyPolicy>
MakeDefaultCommentServiceConnectionIdempotencyPolicy() {
  return std::make_unique<CommentServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2
}  // namespace cloud
}  // namespace google
