// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

#include "google/cloud/securitycenter/v1/internal/security_center_connection_impl.h"
#include "google/cloud/securitycenter/v1/internal/security_center_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace securitycenter_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<securitycenter_v1::SecurityCenterRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<securitycenter_v1::SecurityCenterRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<securitycenter_v1::SecurityCenterBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<securitycenter_v1::SecurityCenterConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<securitycenter_v1::SecurityCenterConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<securitycenter_v1::SecurityCenterPollingPolicyOption>()
      ->clone();
}

}  // namespace

SecurityCenterConnectionImpl::SecurityCenterConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<securitycenter_v1_internal::SecurityCenterStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      SecurityCenterConnection::options())) {}

future<StatusOr<google::cloud::securitycenter::v1::BulkMuteFindingsResponse>>
SecurityCenterConnectionImpl::BulkMuteFindings(
    google::cloud::securitycenter::v1::BulkMuteFindingsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::securitycenter::v1::BulkMuteFindingsResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::securitycenter::v1::BulkMuteFindingsRequest const&
              request) {
        return stub->AsyncBulkMuteFindings(cq, std::move(context), options,
                                           request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::securitycenter::v1::BulkMuteFindingsResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BulkMuteFindings(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::CreateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycenter::v1::
        CreateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSecurityHealthAnalyticsCustomModule(
          request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::
              CreateSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->CreateSecurityHealthAnalyticsCustomModule(context,
                                                                request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::CreateSource(
    google::cloud::securitycenter::v1::CreateSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSource(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::CreateSourceRequest const&
                 request) { return stub_->CreateSource(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::CreateFinding(
    google::cloud::securitycenter::v1::CreateFindingRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFinding(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::CreateFindingRequest const&
                 request) { return stub_->CreateFinding(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::CreateMuteConfig(
    google::cloud::securitycenter::v1::CreateMuteConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::CreateMuteConfigRequest const&
                 request) { return stub_->CreateMuteConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::CreateNotificationConfig(
    google::cloud::securitycenter::v1::CreateNotificationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateNotificationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 CreateNotificationConfigRequest const& request) {
        return stub_->CreateNotificationConfig(context, request);
      },
      request, __func__);
}

Status SecurityCenterConnectionImpl::DeleteMuteConfig(
    google::cloud::securitycenter::v1::DeleteMuteConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::DeleteMuteConfigRequest const&
                 request) { return stub_->DeleteMuteConfig(context, request); },
      request, __func__);
}

Status SecurityCenterConnectionImpl::DeleteNotificationConfig(
    google::cloud::securitycenter::v1::DeleteNotificationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteNotificationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 DeleteNotificationConfigRequest const& request) {
        return stub_->DeleteNotificationConfig(context, request);
      },
      request, __func__);
}

Status SecurityCenterConnectionImpl::DeleteSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycenter::v1::
        DeleteSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSecurityHealthAnalyticsCustomModule(
          request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::
              DeleteSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->DeleteSecurityHealthAnalyticsCustomModule(context,
                                                                request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::BigQueryExport>
SecurityCenterConnectionImpl::GetBigQueryExport(
    google::cloud::securitycenter::v1::GetBigQueryExportRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetBigQueryExport(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::GetBigQueryExportRequest const&
                 request) {
        return stub_->GetBigQueryExport(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> SecurityCenterConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::GetMuteConfig(
    google::cloud::securitycenter::v1::GetMuteConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::GetMuteConfigRequest const&
                 request) { return stub_->GetMuteConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::GetNotificationConfig(
    google::cloud::securitycenter::v1::GetNotificationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNotificationConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::GetNotificationConfigRequest const&
              request) {
        return stub_->GetNotificationConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
SecurityCenterConnectionImpl::GetOrganizationSettings(
    google::cloud::securitycenter::v1::GetOrganizationSettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOrganizationSettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 GetOrganizationSettingsRequest const& request) {
        return stub_->GetOrganizationSettings(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::GetEffectiveSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycenter::v1::
        GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)
          ->GetEffectiveSecurityHealthAnalyticsCustomModule(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&
                     request) {
        return stub_->GetEffectiveSecurityHealthAnalyticsCustomModule(context,
                                                                      request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::GetSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycenter::v1::
        GetSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSecurityHealthAnalyticsCustomModule(
          request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 GetSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->GetSecurityHealthAnalyticsCustomModule(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::GetSource(
    google::cloud::securitycenter::v1::GetSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSource(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::GetSourceRequest const& request) {
        return stub_->GetSource(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::securitycenter::v1::GroupResult>
SecurityCenterConnectionImpl::GroupAssets(
    google::cloud::securitycenter::v1::GroupAssetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->GroupAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::GroupResult>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::GroupAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::GroupAssetsRequest const&
                       request) { return stub->GroupAssets(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::GroupAssetsResponse r) {
        std::vector<google::cloud::securitycenter::v1::GroupResult> result(
            r.group_by_results().size());
        auto& messages = *r.mutable_group_by_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::GroupResult>
SecurityCenterConnectionImpl::GroupFindings(
    google::cloud::securitycenter::v1::GroupFindingsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->GroupFindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::GroupResult>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::GroupFindingsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::securitycenter::v1::GroupFindingsRequest const&
                    request) { return stub->GroupFindings(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::GroupFindingsResponse r) {
        std::vector<google::cloud::securitycenter::v1::GroupResult> result(
            r.group_by_results().size());
        auto& messages = *r.mutable_group_by_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<
    google::cloud::securitycenter::v1::ListAssetsResponse::ListAssetsResult>
SecurityCenterConnectionImpl::ListAssets(
    google::cloud::securitycenter::v1::ListAssetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::securitycenter::v1::ListAssetsResponse::ListAssetsResult>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::ListAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::ListAssetsRequest const&
                       request) { return stub->ListAssets(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListAssetsResponse r) {
        std::vector<google::cloud::securitycenter::v1::ListAssetsResponse::
                        ListAssetsResult>
            result(r.list_assets_results().size());
        auto& messages = *r.mutable_list_assets_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<
    google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycenter::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)
          ->ListDescendantSecurityHealthAnalyticsCustomModules(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::
              ListDescendantSecurityHealthAnalyticsCustomModulesRequest const&
                  r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::securitycenter::v1::
                    ListDescendantSecurityHealthAnalyticsCustomModulesRequest const&
                        request) {
              return stub->ListDescendantSecurityHealthAnalyticsCustomModules(
                  context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::
             ListDescendantSecurityHealthAnalyticsCustomModulesResponse r) {
        std::vector<google::cloud::securitycenter::v1::
                        SecurityHealthAnalyticsCustomModule>
            result(r.security_health_analytics_custom_modules().size());
        auto& messages = *r.mutable_security_health_analytics_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<
    google::cloud::securitycenter::v1::ListFindingsResponse::ListFindingsResult>
SecurityCenterConnectionImpl::ListFindings(
    google::cloud::securitycenter::v1::ListFindingsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::ListFindingsResponse::
                      ListFindingsResult>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::ListFindingsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::ListFindingsRequest const&
                       request) {
              return stub->ListFindings(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListFindingsResponse r) {
        std::vector<google::cloud::securitycenter::v1::ListFindingsResponse::
                        ListFindingsResult>
            result(r.list_findings_results().size());
        auto& messages = *r.mutable_list_findings_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::ListMuteConfigs(
    google::cloud::securitycenter::v1::ListMuteConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListMuteConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::MuteConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::ListMuteConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::securitycenter::v1::ListMuteConfigsRequest const&
                    request) {
              return stub->ListMuteConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListMuteConfigsResponse r) {
        std::vector<google::cloud::securitycenter::v1::MuteConfig> result(
            r.mute_configs().size());
        auto& messages = *r.mutable_mute_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::ListNotificationConfigs(
    google::cloud::securitycenter::v1::ListNotificationConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListNotificationConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::NotificationConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::
              ListNotificationConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::
                       ListNotificationConfigsRequest const& request) {
              return stub->ListNotificationConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListNotificationConfigsResponse r) {
        std::vector<google::cloud::securitycenter::v1::NotificationConfig>
            result(r.notification_configs().size());
        auto& messages = *r.mutable_notification_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::
                EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::ListEffectiveSecurityHealthAnalyticsCustomModules(
    google::cloud::securitycenter::v1::
        ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)
          ->ListEffectiveSecurityHealthAnalyticsCustomModules(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::
                      EffectiveSecurityHealthAnalyticsCustomModule>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::
              ListEffectiveSecurityHealthAnalyticsCustomModulesRequest const&
                  r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::securitycenter::v1::
                    ListEffectiveSecurityHealthAnalyticsCustomModulesRequest const&
                        request) {
              return stub->ListEffectiveSecurityHealthAnalyticsCustomModules(
                  context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::
             ListEffectiveSecurityHealthAnalyticsCustomModulesResponse r) {
        std::vector<google::cloud::securitycenter::v1::
                        EffectiveSecurityHealthAnalyticsCustomModule>
            result(
                r.effective_security_health_analytics_custom_modules().size());
        auto& messages =
            *r.mutable_effective_security_health_analytics_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<
    google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::ListSecurityHealthAnalyticsCustomModules(
    google::cloud::securitycenter::v1::
        ListSecurityHealthAnalyticsCustomModulesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListSecurityHealthAnalyticsCustomModules(
          request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::
              ListSecurityHealthAnalyticsCustomModulesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::
                       ListSecurityHealthAnalyticsCustomModulesRequest const&
                           request) {
              return stub->ListSecurityHealthAnalyticsCustomModules(context,
                                                                    request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::
             ListSecurityHealthAnalyticsCustomModulesResponse r) {
        std::vector<google::cloud::securitycenter::v1::
                        SecurityHealthAnalyticsCustomModule>
            result(r.security_health_analytics_custom_modules().size());
        auto& messages = *r.mutable_security_health_analytics_custom_modules();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::ListSources(
    google::cloud::securitycenter::v1::ListSourcesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSources(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::Source>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::ListSourcesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::ListSourcesRequest const&
                       request) { return stub->ListSources(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListSourcesResponse r) {
        std::vector<google::cloud::securitycenter::v1::Source> result(
            r.sources().size());
        auto& messages = *r.mutable_sources();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>>
SecurityCenterConnectionImpl::RunAssetDiscovery(
    google::cloud::securitycenter::v1::RunAssetDiscoveryRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::securitycenter::v1::RunAssetDiscoveryRequest const&
              request) {
        return stub->AsyncRunAssetDiscovery(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunAssetDiscovery(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::SetFindingState(
    google::cloud::securitycenter::v1::SetFindingStateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetFindingState(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::SetFindingStateRequest const&
                 request) { return stub_->SetFindingState(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::SetMute(
    google::cloud::securitycenter::v1::SetMuteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetMute(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::SetMuteRequest const& request) {
        return stub_->SetMute(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> SecurityCenterConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecurityCenterConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterConnectionImpl::SimulateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycenter::v1::
        SimulateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SimulateSecurityHealthAnalyticsCustomModule(
          request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 SimulateSecurityHealthAnalyticsCustomModuleRequest const&
                     request) {
        return stub_->SimulateSecurityHealthAnalyticsCustomModule(context,
                                                                  request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::ExternalSystem>
SecurityCenterConnectionImpl::UpdateExternalSystem(
    google::cloud::securitycenter::v1::UpdateExternalSystemRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateExternalSystem(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::UpdateExternalSystemRequest const&
              request) {
        return stub_->UpdateExternalSystem(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::UpdateFinding(
    google::cloud::securitycenter::v1::UpdateFindingRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFinding(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::UpdateFindingRequest const&
                 request) { return stub_->UpdateFinding(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::UpdateMuteConfig(
    google::cloud::securitycenter::v1::UpdateMuteConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::UpdateMuteConfigRequest const&
                 request) { return stub_->UpdateMuteConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::UpdateNotificationConfig(
    google::cloud::securitycenter::v1::UpdateNotificationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateNotificationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 UpdateNotificationConfigRequest const& request) {
        return stub_->UpdateNotificationConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
SecurityCenterConnectionImpl::UpdateOrganizationSettings(
    google::cloud::securitycenter::v1::UpdateOrganizationSettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateOrganizationSettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 UpdateOrganizationSettingsRequest const& request) {
        return stub_->UpdateOrganizationSettings(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::SecurityHealthAnalyticsCustomModule>
SecurityCenterConnectionImpl::UpdateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycenter::v1::
        UpdateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSecurityHealthAnalyticsCustomModule(
          request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::
              UpdateSecurityHealthAnalyticsCustomModuleRequest const& request) {
        return stub_->UpdateSecurityHealthAnalyticsCustomModule(context,
                                                                request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::UpdateSource(
    google::cloud::securitycenter::v1::UpdateSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSource(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::UpdateSourceRequest const&
                 request) { return stub_->UpdateSource(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::SecurityMarks>
SecurityCenterConnectionImpl::UpdateSecurityMarks(
    google::cloud::securitycenter::v1::UpdateSecurityMarksRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSecurityMarks(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::UpdateSecurityMarksRequest const&
              request) { return stub_->UpdateSecurityMarks(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::BigQueryExport>
SecurityCenterConnectionImpl::CreateBigQueryExport(
    google::cloud::securitycenter::v1::CreateBigQueryExportRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateBigQueryExport(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::CreateBigQueryExportRequest const&
              request) {
        return stub_->CreateBigQueryExport(context, request);
      },
      request, __func__);
}

Status SecurityCenterConnectionImpl::DeleteBigQueryExport(
    google::cloud::securitycenter::v1::DeleteBigQueryExportRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteBigQueryExport(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::DeleteBigQueryExportRequest const&
              request) {
        return stub_->DeleteBigQueryExport(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::BigQueryExport>
SecurityCenterConnectionImpl::UpdateBigQueryExport(
    google::cloud::securitycenter::v1::UpdateBigQueryExportRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateBigQueryExport(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::UpdateBigQueryExportRequest const&
              request) {
        return stub_->UpdateBigQueryExport(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::securitycenter::v1::BigQueryExport>
SecurityCenterConnectionImpl::ListBigQueryExports(
    google::cloud::securitycenter::v1::ListBigQueryExportsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListBigQueryExports(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::BigQueryExport>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<securitycenter_v1::SecurityCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::securitycenter::v1::ListBigQueryExportsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::
                       ListBigQueryExportsRequest const& request) {
              return stub->ListBigQueryExports(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListBigQueryExportsResponse r) {
        std::vector<google::cloud::securitycenter::v1::BigQueryExport> result(
            r.big_query_exports().size());
        auto& messages = *r.mutable_big_query_exports();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter_v1_internal
}  // namespace cloud
}  // namespace google
