// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#include "google/cloud/gkehub/v1/internal/gke_hub_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkehub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GkeHubTracingConnection::GkeHubTracingConnection(
    std::shared_ptr<gkehub_v1::GkeHubConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::gkehub::v1::Membership>
GkeHubTracingConnection::ListMemberships(
    google::cloud::gkehub::v1::ListMembershipsRequest request) {
  auto span =
      internal::MakeSpan("gkehub_v1::GkeHubConnection::ListMemberships");
  internal::OTelScope scope(span);
  auto sr = child_->ListMemberships(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::gkehub::v1::Membership>(
      std::move(span), std::move(sr));
}

StreamRange<google::cloud::gkehub::v1::Feature>
GkeHubTracingConnection::ListFeatures(
    google::cloud::gkehub::v1::ListFeaturesRequest request) {
  auto span = internal::MakeSpan("gkehub_v1::GkeHubConnection::ListFeatures");
  internal::OTelScope scope(span);
  auto sr = child_->ListFeatures(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::gkehub::v1::Feature>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::gkehub::v1::Membership>
GkeHubTracingConnection::GetMembership(
    google::cloud::gkehub::v1::GetMembershipRequest const& request) {
  auto span = internal::MakeSpan("gkehub_v1::GkeHubConnection::GetMembership");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMembership(request));
}

StatusOr<google::cloud::gkehub::v1::Feature>
GkeHubTracingConnection::GetFeature(
    google::cloud::gkehub::v1::GetFeatureRequest const& request) {
  auto span = internal::MakeSpan("gkehub_v1::GkeHubConnection::GetFeature");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFeature(request));
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubTracingConnection::CreateMembership(
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  auto span =
      internal::MakeSpan("gkehub_v1::GkeHubConnection::CreateMembership");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateMembership(request));
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubTracingConnection::CreateFeature(
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  auto span = internal::MakeSpan("gkehub_v1::GkeHubConnection::CreateFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateFeature(request));
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubTracingConnection::DeleteMembership(
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  auto span =
      internal::MakeSpan("gkehub_v1::GkeHubConnection::DeleteMembership");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteMembership(request));
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubTracingConnection::DeleteFeature(
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  auto span = internal::MakeSpan("gkehub_v1::GkeHubConnection::DeleteFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteFeature(request));
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubTracingConnection::UpdateMembership(
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  auto span =
      internal::MakeSpan("gkehub_v1::GkeHubConnection::UpdateMembership");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateMembership(request));
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubTracingConnection::UpdateFeature(
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  auto span = internal::MakeSpan("gkehub_v1::GkeHubConnection::UpdateFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateFeature(request));
}

StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
GkeHubTracingConnection::GenerateConnectManifest(
    google::cloud::gkehub::v1::GenerateConnectManifestRequest const& request) {
  auto span = internal::MakeSpan(
      "gkehub_v1::GkeHubConnection::GenerateConnectManifest");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateConnectManifest(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<gkehub_v1::GkeHubConnection> MakeGkeHubTracingConnection(
    std::shared_ptr<gkehub_v1::GkeHubConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GkeHubTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1_internal
}  // namespace cloud
}  // namespace google
