// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_INDEX_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_INDEX_TRACING_CONNECTION_H

#include "google/cloud/aiplatform/v1/index_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class IndexServiceTracingConnection
    : public aiplatform_v1::IndexServiceConnection {
 public:
  ~IndexServiceTracingConnection() override = default;

  explicit IndexServiceTracingConnection(
      std::shared_ptr<aiplatform_v1::IndexServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::aiplatform::v1::Index>> CreateIndex(
      google::cloud::aiplatform::v1::CreateIndexRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Index> GetIndex(
      google::cloud::aiplatform::v1::GetIndexRequest const& request) override;

  StreamRange<google::cloud::aiplatform::v1::Index> ListIndexes(
      google::cloud::aiplatform::v1::ListIndexesRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::Index>> UpdateIndex(
      google::cloud::aiplatform::v1::UpdateIndexRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteIndex(google::cloud::aiplatform::v1::DeleteIndexRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::UpsertDatapointsResponse>
  UpsertDatapoints(google::cloud::aiplatform::v1::UpsertDatapointsRequest const&
                       request) override;

  StatusOr<google::cloud::aiplatform::v1::RemoveDatapointsResponse>
  RemoveDatapoints(google::cloud::aiplatform::v1::RemoveDatapointsRequest const&
                       request) override;

 private:
  std::shared_ptr<aiplatform_v1::IndexServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<aiplatform_v1::IndexServiceConnection>
MakeIndexServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::IndexServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_INDEX_TRACING_CONNECTION_H
